@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Image reference information. Used in the virtual machine profile.
 * @property exactVersion The actual version of the image after use.
 * @property id Image resource ID
 * @property offer The image offer if applicable.
 * @property publisher The image publisher
 * @property sku The image SKU
 * @property version The image version specified on creation.
 */
public data class ImageReferenceResponse(
    public val exactVersion: String,
    public val id: String? = null,
    public val offer: String? = null,
    public val publisher: String? = null,
    public val sku: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.ImageReferenceResponse):
            ImageReferenceResponse = ImageReferenceResponse(
            exactVersion = javaType.exactVersion(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            offer = javaType.offer().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
