@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the status of an operation.
 * @property errorCode Error code on failure.
 * @property errorMessage The error message.
 * @property httpMethod The HttpMethod - PUT/POST/DELETE for the operation.
 * @property operationUrl The URL to use to check long-running operation status
 * @property requestUri Request URI of the operation.
 * @property status The current status of the operation.
 */
public data class LatestOperationResultResponse(
    public val errorCode: String,
    public val errorMessage: String,
    public val httpMethod: String,
    public val operationUrl: String,
    public val requestUri: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.LatestOperationResultResponse):
            LatestOperationResultResponse = LatestOperationResultResponse(
            errorCode = javaType.errorCode(),
            errorMessage = javaType.errorMessage(),
            httpMethod = javaType.httpMethod(),
            operationUrl = javaType.operationUrl(),
            requestUri = javaType.requestUri(),
            status = javaType.status(),
        )
    }
}
