@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Network details of the environment
 * @property privateIpAddress PrivateIp address of the Compute VM
 * @property rdpAuthority Connection information for Windows
 * @property sshAuthority Connection information for Linux
 * @property username Username of the VM
 */
public data class NetworkInterfaceResponse(
    public val privateIpAddress: String,
    public val rdpAuthority: String,
    public val sshAuthority: String,
    public val username: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.NetworkInterfaceResponse):
            NetworkInterfaceResponse = NetworkInterfaceResponse(
            privateIpAddress = javaType.privateIpAddress(),
            rdpAuthority = javaType.rdpAuthority(),
            sshAuthority = javaType.sshAuthority(),
            username = javaType.username(),
        )
    }
}
