@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a VM and the setting Id it was created for.
 * @property resourceSettingId resourceSettingId for the environment
 * @property vmResourceId VM resource Id for the environment
 */
public data class ResourceSetResponse(
    public val resourceSettingId: String? = null,
    public val vmResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.ResourceSetResponse):
            ResourceSetResponse = ResourceSetResponse(
            resourceSettingId = javaType.resourceSettingId().map({ args0 -> args0 }).orElse(null),
            vmResourceId = javaType.vmResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
