@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Represents the size information
 * @property isAvailable Whether or not this size category is available
 * @property sizeCategory The category of the size (Basic, Standard, Performance).
 */
public data class SizeAvailabilityResponse(
    public val isAvailable: Boolean? = null,
    public val sizeCategory: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.SizeAvailabilityResponse):
            SizeAvailabilityResponse = SizeAvailabilityResponse(
            isAvailable = javaType.isAvailable().map({ args0 -> args0 }).orElse(null),
            sizeCategory = javaType.sizeCategory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
