@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Contains detailed information about a size
 * @property computeSize Represents the actual compute size, e.g. Standard_A2_v2.
 * @property memory The amount of memory available (in GB).
 * @property numberOfCores The number of cores a VM of this size has.
 * @property price The pay-as-you-go price per hour this size will cost. It does not include discounts and may not reflect the actual price the size will cost.
 */
public data class SizeInfoResponse(
    public val computeSize: String? = null,
    public val memory: Double? = null,
    public val numberOfCores: Int? = null,
    public val price: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.SizeInfoResponse):
            SizeInfoResponse = SizeInfoResponse(
            computeSize = javaType.computeSize().map({ args0 -> args0 }).orElse(null),
            memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
            numberOfCores = javaType.numberOfCores().map({ args0 -> args0 }).orElse(null),
            price = javaType.price().map({ args0 -> args0 }).orElse(null),
        )
    }
}
