@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The base virtual machine configuration for a lab.
 * @property additionalCapabilities Additional VM capabilities.
 * @property adminUser Credentials for the admin user on the VM.
 * @property createOption Indicates what lab virtual machines are created from.
 * @property imageReference The image configuration for lab virtual machines.
 * @property nonAdminUser Credentials for the non-admin user on the VM, if one exists.
 * @property osType The OS type of the image
 * @property sku The SKU for the lab. Defines the type of virtual machines used in the lab.
 * @property usageQuota The initial quota alloted to each lab user. Must be a time span between 0 and 9999 hours.
 * @property useSharedPassword Enabling this option will use the same password for all user VMs.
 */
public data class VirtualMachineProfileResponse(
    public val additionalCapabilities: VirtualMachineAdditionalCapabilitiesResponse? = null,
    public val adminUser: CredentialsResponse,
    public val createOption: String,
    public val imageReference: ImageReferenceResponse,
    public val nonAdminUser: CredentialsResponse? = null,
    public val osType: String,
    public val sku: SkuResponse,
    public val usageQuota: String,
    public val useSharedPassword: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.labservices.outputs.VirtualMachineProfileResponse):
            VirtualMachineProfileResponse = VirtualMachineProfileResponse(
            additionalCapabilities = javaType.additionalCapabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.labservices.kotlin.outputs.VirtualMachineAdditionalCapabilitiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            adminUser = javaType.adminUser().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.CredentialsResponse.Companion.toKotlin(args0)
            }),
            createOption = javaType.createOption(),
            imageReference = javaType.imageReference().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.ImageReferenceResponse.Companion.toKotlin(args0)
            }),
            nonAdminUser = javaType.nonAdminUser().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.labservices.kotlin.outputs.CredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osType = javaType.osType(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.labservices.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            usageQuota = javaType.usageQuota(),
            useSharedPassword = javaType.useSharedPassword().map({ args0 -> args0 }).orElse(null),
        )
    }
}
