@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.loadtestservice.kotlin

import com.pulumi.azurenative.loadtestservice.LoadTestArgs.builder
import com.pulumi.azurenative.loadtestservice.kotlin.inputs.EncryptionPropertiesArgs
import com.pulumi.azurenative.loadtestservice.kotlin.inputs.EncryptionPropertiesArgsBuilder
import com.pulumi.azurenative.loadtestservice.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.loadtestservice.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * LoadTest details
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * Other available API versions: 2021-12-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:loadtestservice:LoadTest myLoadTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LoadTestService/loadTests/{loadTestName}
 * ```
 * @property description Description of the resource.
 * @property encryption CMK Encryption property.
 * @property identity The type of identity used for the resource.
 * @property loadTestName Load Test name.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class LoadTestArgs(
    public val description: Output<String>? = null,
    public val encryption: Output<EncryptionPropertiesArgs>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val loadTestName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.loadtestservice.LoadTestArgs> {
    override fun toJava(): com.pulumi.azurenative.loadtestservice.LoadTestArgs =
        com.pulumi.azurenative.loadtestservice.LoadTestArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .loadTestName(loadTestName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LoadTestArgs].
 */
@PulumiTagMarker
public class LoadTestArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var encryption: Output<EncryptionPropertiesArgs>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var loadTestName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description of the resource.
     */
    @JvmName("lgfmhrlohvfacwbo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value CMK Encryption property.
     */
    @JvmName("othlqneqptnriqjp")
    public suspend fun encryption(`value`: Output<EncryptionPropertiesArgs>) {
        this.encryption = value
    }

    /**
     * @param value The type of identity used for the resource.
     */
    @JvmName("ijrxmabjeaeyabnf")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Load Test name.
     */
    @JvmName("uqoilgvoamjfkyxv")
    public suspend fun loadTestName(`value`: Output<String>) {
        this.loadTestName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bnbhajowgvkysonw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rwxqxljipuwerhik")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jxpoblapfjusqsjx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description of the resource.
     */
    @JvmName("gmwljrcvutcudiay")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value CMK Encryption property.
     */
    @JvmName("mtnrjncdoxnejiat")
    public suspend fun encryption(`value`: EncryptionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument CMK Encryption property.
     */
    @JvmName("aogiegcbnhmwrsuk")
    public suspend fun encryption(argument: suspend EncryptionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The type of identity used for the resource.
     */
    @JvmName("uoyxgjkejdlvdmip")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The type of identity used for the resource.
     */
    @JvmName("qyfwautcmgmurtrw")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Load Test name.
     */
    @JvmName("ulmamwibuoifmfqu")
    public suspend fun loadTestName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadTestName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fivyidcuqndjgtdp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yxvekdhtctbivsvn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("suhsceuiygiserie")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wbainnukokbrpesn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LoadTestArgs = LoadTestArgs(
        description = description,
        encryption = encryption,
        identity = identity,
        loadTestName = loadTestName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
