@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.kotlin.outputs.KeyVaultKeyReferenceResponse
import com.pulumi.azurenative.logic.kotlin.outputs.KeyVaultKeyReferenceResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [IntegrationAccountCertificate].
 */
@PulumiTagMarker
public class IntegrationAccountCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationAccountCertificateArgs = IntegrationAccountCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationAccountCertificateArgsBuilder.() -> Unit) {
        val builder = IntegrationAccountCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IntegrationAccountCertificate {
        val builtJavaResource =
            com.pulumi.azurenative.logic.IntegrationAccountCertificate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IntegrationAccountCertificate(builtJavaResource)
    }
}

/**
 * The integration account certificate.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2015-08-01-preview.
 * ## Example Usage
 * ### Create or update a certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountCertificate = new AzureNative.Logic.IntegrationAccountCertificate("integrationAccountCertificate", new()
 *     {
 *         CertificateName = "testCertificate",
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Key = new AzureNative.Logic.Inputs.KeyVaultKeyReferenceArgs
 *         {
 *             KeyName = "<keyName>",
 *             KeyVault = new AzureNative.Logic.Inputs.KeyVaultKeyReferenceKeyVaultArgs
 *             {
 *                 Id = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testResourceGroup/providers/microsoft.keyvault/vaults/<keyVaultName>",
 *             },
 *             KeyVersion = "87d9764197604449b9b8eb7bd8710868",
 *         },
 *         Location = "brazilsouth",
 *         PublicCertificate = "<publicCertificateValue>",
 *         ResourceGroupName = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccountCertificate(ctx, "integrationAccountCertificate", &logic.IntegrationAccountCertificateArgs{
 * 			CertificateName:        pulumi.String("testCertificate"),
 * 			IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * 			Key: logic.KeyVaultKeyReferenceResponse{
 * 				KeyName: pulumi.String("<keyName>"),
 * 				KeyVault: &logic.KeyVaultKeyReferenceKeyVaultArgs{
 * 					Id: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testResourceGroup/providers/microsoft.keyvault/vaults/<keyVaultName>"),
 * 				},
 * 				KeyVersion: pulumi.String("87d9764197604449b9b8eb7bd8710868"),
 * 			},
 * 			Location:          pulumi.String("brazilsouth"),
 * 			PublicCertificate: pulumi.String("<publicCertificateValue>"),
 * 			ResourceGroupName: pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountCertificate;
 * import com.pulumi.azurenative.logic.IntegrationAccountCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountCertificate = new IntegrationAccountCertificate("integrationAccountCertificate", IntegrationAccountCertificateArgs.builder()
 *             .certificateName("testCertificate")
 *             .integrationAccountName("testIntegrationAccount")
 *             .key(Map.ofEntries(
 *                 Map.entry("keyName", "<keyName>"),
 *                 Map.entry("keyVault", Map.of("id", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testResourceGroup/providers/microsoft.keyvault/vaults/<keyVaultName>")),
 *                 Map.entry("keyVersion", "87d9764197604449b9b8eb7bd8710868")
 *             ))
 *             .location("brazilsouth")
 *             .publicCertificate("<publicCertificateValue>")
 *             .resourceGroupName("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccountCertificate testCertificate /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/certificates/{certificateName}
 * ```
 */
public class IntegrationAccountCertificate internal constructor(
    override val javaResource: com.pulumi.azurenative.logic.IntegrationAccountCertificate,
) : KotlinCustomResource(javaResource, IntegrationAccountCertificateMapper) {
    /**
     * The changed time.
     */
    public val changedTime: Output<String>
        get() = javaResource.changedTime().applyValue({ args0 -> args0 })

    /**
     * The created time.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * The key details in the key vault.
     */
    public val key: Output<KeyVaultKeyReferenceResponse>?
        get() = javaResource.key().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The metadata.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The public certificate.
     */
    public val publicCertificate: Output<String>?
        get() = javaResource.publicCertificate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets the resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IntegrationAccountCertificateMapper : ResourceMapper<IntegrationAccountCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.logic.IntegrationAccountCertificate::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationAccountCertificate =
        IntegrationAccountCertificate(
            javaResource as
                com.pulumi.azurenative.logic.IntegrationAccountCertificate,
        )
}

/**
 * @see [IntegrationAccountCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationAccountCertificate].
 */
public suspend fun integrationAccountCertificate(
    name: String,
    block: suspend IntegrationAccountCertificateResourceBuilder.() -> Unit,
):
    IntegrationAccountCertificate {
    val builder = IntegrationAccountCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationAccountCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationAccountCertificate(name: String): IntegrationAccountCertificate {
    val builder = IntegrationAccountCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
