@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.IntegrationAccountCertificateArgs.builder
import com.pulumi.azurenative.logic.kotlin.inputs.KeyVaultKeyReferenceArgs
import com.pulumi.azurenative.logic.kotlin.inputs.KeyVaultKeyReferenceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The integration account certificate.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2015-08-01-preview.
 * ## Example Usage
 * ### Create or update a certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountCertificate = new AzureNative.Logic.IntegrationAccountCertificate("integrationAccountCertificate", new()
 *     {
 *         CertificateName = "testCertificate",
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Key = new AzureNative.Logic.Inputs.KeyVaultKeyReferenceArgs
 *         {
 *             KeyName = "<keyName>",
 *             KeyVault = new AzureNative.Logic.Inputs.KeyVaultKeyReferenceKeyVaultArgs
 *             {
 *                 Id = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testResourceGroup/providers/microsoft.keyvault/vaults/<keyVaultName>",
 *             },
 *             KeyVersion = "87d9764197604449b9b8eb7bd8710868",
 *         },
 *         Location = "brazilsouth",
 *         PublicCertificate = "<publicCertificateValue>",
 *         ResourceGroupName = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationAccountCertificate(ctx, "integrationAccountCertificate", &logic.IntegrationAccountCertificateArgs{
 * 			CertificateName:        pulumi.String("testCertificate"),
 * 			IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * 			Key: logic.KeyVaultKeyReferenceResponse{
 * 				KeyName: pulumi.String("<keyName>"),
 * 				KeyVault: &logic.KeyVaultKeyReferenceKeyVaultArgs{
 * 					Id: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testResourceGroup/providers/microsoft.keyvault/vaults/<keyVaultName>"),
 * 				},
 * 				KeyVersion: pulumi.String("87d9764197604449b9b8eb7bd8710868"),
 * 			},
 * 			Location:          pulumi.String("brazilsouth"),
 * 			PublicCertificate: pulumi.String("<publicCertificateValue>"),
 * 			ResourceGroupName: pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountCertificate;
 * import com.pulumi.azurenative.logic.IntegrationAccountCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountCertificate = new IntegrationAccountCertificate("integrationAccountCertificate", IntegrationAccountCertificateArgs.builder()
 *             .certificateName("testCertificate")
 *             .integrationAccountName("testIntegrationAccount")
 *             .key(Map.ofEntries(
 *                 Map.entry("keyName", "<keyName>"),
 *                 Map.entry("keyVault", Map.of("id", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testResourceGroup/providers/microsoft.keyvault/vaults/<keyVaultName>")),
 *                 Map.entry("keyVersion", "87d9764197604449b9b8eb7bd8710868")
 *             ))
 *             .location("brazilsouth")
 *             .publicCertificate("<publicCertificateValue>")
 *             .resourceGroupName("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccountCertificate testCertificate /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/certificates/{certificateName}
 * ```
 * @property certificateName The integration account certificate name.
 * @property integrationAccountName The integration account name.
 * @property key The key details in the key vault.
 * @property location The resource location.
 * @property metadata The metadata.
 * @property publicCertificate The public certificate.
 * @property resourceGroupName The resource group name.
 * @property tags The resource tags.
 */
public data class IntegrationAccountCertificateArgs(
    public val certificateName: Output<String>? = null,
    public val integrationAccountName: Output<String>? = null,
    public val key: Output<KeyVaultKeyReferenceArgs>? = null,
    public val location: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val publicCertificate: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.IntegrationAccountCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.IntegrationAccountCertificateArgs =
        com.pulumi.azurenative.logic.IntegrationAccountCertificateArgs.builder()
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .integrationAccountName(integrationAccountName?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .publicCertificate(publicCertificate?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IntegrationAccountCertificateArgs].
 */
@PulumiTagMarker
public class IntegrationAccountCertificateArgsBuilder internal constructor() {
    private var certificateName: Output<String>? = null

    private var integrationAccountName: Output<String>? = null

    private var key: Output<KeyVaultKeyReferenceArgs>? = null

    private var location: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var publicCertificate: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The integration account certificate name.
     */
    @JvmName("ynhxyaqwfxfkadcc")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("ggfmqmqdtvdbyljx")
    public suspend fun integrationAccountName(`value`: Output<String>) {
        this.integrationAccountName = value
    }

    /**
     * @param value The key details in the key vault.
     */
    @JvmName("cwqjhhdbrxkyljqo")
    public suspend fun key(`value`: Output<KeyVaultKeyReferenceArgs>) {
        this.key = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("fuuvmcigsynvghlf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The metadata.
     */
    @JvmName("ddewvrlwmnyqlehs")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The public certificate.
     */
    @JvmName("mfpqbfvfceiftrfp")
    public suspend fun publicCertificate(`value`: Output<String>) {
        this.publicCertificate = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("kcmlohpgdrvxqanc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("ytwvbqhbgxldbvqa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The integration account certificate name.
     */
    @JvmName("hocnnfqecdjddlov")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("swltxrtmupvwtrww")
    public suspend fun integrationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The key details in the key vault.
     */
    @JvmName("hmbmaqpwirtapafp")
    public suspend fun key(`value`: KeyVaultKeyReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param argument The key details in the key vault.
     */
    @JvmName("xvnoccjesygxjaby")
    public suspend fun key(argument: suspend KeyVaultKeyReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultKeyReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.key = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("igkersijddkvfrhh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The metadata.
     */
    @JvmName("eogycxrqalqooggn")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The public certificate.
     */
    @JvmName("reutfrvgakhjxcpn")
    public suspend fun publicCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicCertificate = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ueojpalftyknrtae")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("nbeqfuyqmavvqnlq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("wjvhtmajstfjdbfy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IntegrationAccountCertificateArgs = IntegrationAccountCertificateArgs(
        certificateName = certificateName,
        integrationAccountName = integrationAccountName,
        key = key,
        location = location,
        metadata = metadata,
        publicCertificate = publicCertificate,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
