@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.IntegrationAccountPartnerArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.PartnerType
import com.pulumi.azurenative.logic.kotlin.inputs.PartnerContentArgs
import com.pulumi.azurenative.logic.kotlin.inputs.PartnerContentArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The integration account partner.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2015-08-01-preview.
 * ## Example Usage
 * ### Create or update a partner
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationAccountPartner = new AzureNative.Logic.IntegrationAccountPartner("integrationAccountPartner", new()
 *     {
 *         Content = new AzureNative.Logic.Inputs.PartnerContentArgs
 *         {
 *             B2b = new AzureNative.Logic.Inputs.B2BPartnerContentArgs
 *             {
 *                 BusinessIdentities = new[]
 *                 {
 *                     new AzureNative.Logic.Inputs.BusinessIdentityArgs
 *                     {
 *                         Qualifier = "AA",
 *                         Value = "ZZ",
 *                     },
 *                 },
 *             },
 *         },
 *         IntegrationAccountName = "testIntegrationAccount",
 *         Location = "westus",
 *         Metadata = null,
 *         PartnerName = "testPartner",
 *         PartnerType = "B2B",
 *         ResourceGroupName = "testResourceGroup",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := logic.NewIntegrationAccountPartner(ctx, "integrationAccountPartner", &logic.IntegrationAccountPartnerArgs{
 * Content: logic.PartnerContentResponse{
 * B2b: interface{}{
 * BusinessIdentities: logic.BusinessIdentityArray{
 * &logic.BusinessIdentityArgs{
 * Qualifier: pulumi.String("AA"),
 * Value: pulumi.String("ZZ"),
 * },
 * },
 * },
 * },
 * IntegrationAccountName: pulumi.String("testIntegrationAccount"),
 * Location: pulumi.String("westus"),
 * Metadata: nil,
 * PartnerName: pulumi.String("testPartner"),
 * PartnerType: pulumi.String("B2B"),
 * ResourceGroupName: pulumi.String("testResourceGroup"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationAccountPartner;
 * import com.pulumi.azurenative.logic.IntegrationAccountPartnerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationAccountPartner = new IntegrationAccountPartner("integrationAccountPartner", IntegrationAccountPartnerArgs.builder()
 *             .content(Map.of("b2b", Map.of("businessIdentities", Map.ofEntries(
 *                 Map.entry("qualifier", "AA"),
 *                 Map.entry("value", "ZZ")
 *             ))))
 *             .integrationAccountName("testIntegrationAccount")
 *             .location("westus")
 *             .metadata()
 *             .partnerName("testPartner")
 *             .partnerType("B2B")
 *             .resourceGroupName("testResourceGroup")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationAccountPartner testPartner /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/partners/{partnerName}
 * ```
 * @property content The partner content.
 * @property integrationAccountName The integration account name.
 * @property location The resource location.
 * @property metadata The metadata.
 * @property partnerName The integration account partner name.
 * @property partnerType The partner type.
 * @property resourceGroupName The resource group name.
 * @property tags The resource tags.
 */
public data class IntegrationAccountPartnerArgs(
    public val content: Output<PartnerContentArgs>? = null,
    public val integrationAccountName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val partnerName: Output<String>? = null,
    public val partnerType: Output<Either<String, PartnerType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.IntegrationAccountPartnerArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.IntegrationAccountPartnerArgs =
        com.pulumi.azurenative.logic.IntegrationAccountPartnerArgs.builder()
            .content(content?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .integrationAccountName(integrationAccountName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .partnerName(partnerName?.applyValue({ args0 -> args0 }))
            .partnerType(
                partnerType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IntegrationAccountPartnerArgs].
 */
@PulumiTagMarker
public class IntegrationAccountPartnerArgsBuilder internal constructor() {
    private var content: Output<PartnerContentArgs>? = null

    private var integrationAccountName: Output<String>? = null

    private var location: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var partnerName: Output<String>? = null

    private var partnerType: Output<Either<String, PartnerType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The partner content.
     */
    @JvmName("aoalxsrjjkrqibhe")
    public suspend fun content(`value`: Output<PartnerContentArgs>) {
        this.content = value
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("sppnmpshbqxmrasi")
    public suspend fun integrationAccountName(`value`: Output<String>) {
        this.integrationAccountName = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("otsvhlthjlxpmrmu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The metadata.
     */
    @JvmName("dlhfaytdxyqduxna")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The integration account partner name.
     */
    @JvmName("efihpiyvufmbulax")
    public suspend fun partnerName(`value`: Output<String>) {
        this.partnerName = value
    }

    /**
     * @param value The partner type.
     */
    @JvmName("uunynleilutdphna")
    public suspend fun partnerType(`value`: Output<Either<String, PartnerType>>) {
        this.partnerType = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("vmurvmfenfkvibqu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("udlwegyouvjiskhh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The partner content.
     */
    @JvmName("eaeomirmwsreirsd")
    public suspend fun content(`value`: PartnerContentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param argument The partner content.
     */
    @JvmName("kbmwbavwtmcmpxkt")
    public suspend fun content(argument: suspend PartnerContentArgsBuilder.() -> Unit) {
        val toBeMapped = PartnerContentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.content = mapped
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("adlmmgmkxbpvyola")
    public suspend fun integrationAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("jxadkrylswnwsvuw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The metadata.
     */
    @JvmName("xbjamesvbyroyohw")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The integration account partner name.
     */
    @JvmName("arhmhwhonsnbwqmn")
    public suspend fun partnerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerName = mapped
    }

    /**
     * @param value The partner type.
     */
    @JvmName("cxjbjmorbfpibgfr")
    public suspend fun partnerType(`value`: Either<String, PartnerType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerType = mapped
    }

    /**
     * @param value The partner type.
     */
    @JvmName("xejialujvjtjwaig")
    public fun partnerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PartnerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partnerType = mapped
    }

    /**
     * @param value The partner type.
     */
    @JvmName("umsraptblofvxcgt")
    public fun partnerType(`value`: PartnerType) {
        val toBeMapped = Either.ofRight<String, PartnerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partnerType = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("kafiwirspjxtknku")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("mhoxrfnaxprcljon")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("jsqhagelpltqqmrv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IntegrationAccountPartnerArgs = IntegrationAccountPartnerArgs(
        content = content,
        integrationAccountName = integrationAccountName,
        location = location,
        metadata = metadata,
        partnerName = partnerName,
        partnerType = partnerType,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
