@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.kotlin.outputs.IntegrationServiceEnvironmentPropertiesResponse
import com.pulumi.azurenative.logic.kotlin.outputs.IntegrationServiceEnvironmentSkuResponse
import com.pulumi.azurenative.logic.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.logic.kotlin.outputs.IntegrationServiceEnvironmentPropertiesResponse.Companion.toKotlin as integrationServiceEnvironmentPropertiesResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.IntegrationServiceEnvironmentSkuResponse.Companion.toKotlin as integrationServiceEnvironmentSkuResponseToKotlin
import com.pulumi.azurenative.logic.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin

/**
 * Builder for [IntegrationServiceEnvironment].
 */
@PulumiTagMarker
public class IntegrationServiceEnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationServiceEnvironmentArgs = IntegrationServiceEnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationServiceEnvironmentArgsBuilder.() -> Unit) {
        val builder = IntegrationServiceEnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IntegrationServiceEnvironment {
        val builtJavaResource =
            com.pulumi.azurenative.logic.IntegrationServiceEnvironment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IntegrationServiceEnvironment(builtJavaResource)
    }
}

/**
 * The integration service environment.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * ## Example Usage
 * ### Create or update an integration service environment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationServiceEnvironment = new AzureNative.Logic.IntegrationServiceEnvironment("integrationServiceEnvironment", new()
 *     {
 *         IntegrationServiceEnvironmentName = "testIntegrationServiceEnvironment",
 *         Location = "brazilsouth",
 *         Properties = new AzureNative.Logic.Inputs.IntegrationServiceEnvironmentPropertiesArgs
 *         {
 *             EncryptionConfiguration = new AzureNative.Logic.Inputs.IntegrationServiceEnvironmenEncryptionConfigurationArgs
 *             {
 *                 EncryptionKeyReference = new AzureNative.Logic.Inputs.IntegrationServiceEnvironmenEncryptionKeyReferenceArgs
 *                 {
 *                     KeyName = "testKeyName",
 *                     KeyVault = new AzureNative.Logic.Inputs.ResourceReferenceArgs
 *                     {
 *                         Id = "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.KeyVault/vaults/testKeyVault",
 *                     },
 *                     KeyVersion = "13b261d30b984753869902d7f47f4d55",
 *                 },
 *             },
 *             NetworkConfiguration = new AzureNative.Logic.Inputs.NetworkConfigurationArgs
 *             {
 *                 AccessEndpoint = new AzureNative.Logic.Inputs.IntegrationServiceEnvironmentAccessEndpointArgs
 *                 {
 *                     Type = "Internal",
 *                 },
 *                 Subnets = new[]
 *                 {
 *                     new AzureNative.Logic.Inputs.ResourceReferenceArgs
 *                     {
 *                         Id = "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s1",
 *                     },
 *                     new AzureNative.Logic.Inputs.ResourceReferenceArgs
 *                     {
 *                         Id = "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s2",
 *                     },
 *                     new AzureNative.Logic.Inputs.ResourceReferenceArgs
 *                     {
 *                         Id = "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s3",
 *                     },
 *                     new AzureNative.Logic.Inputs.ResourceReferenceArgs
 *                     {
 *                         Id = "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s4",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroup = "testResourceGroup",
 *         Sku = new AzureNative.Logic.Inputs.IntegrationServiceEnvironmentSkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "Premium",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := logic.NewIntegrationServiceEnvironment(ctx, "integrationServiceEnvironment", &logic.IntegrationServiceEnvironmentArgs{
 * IntegrationServiceEnvironmentName: pulumi.String("testIntegrationServiceEnvironment"),
 * Location: pulumi.String("brazilsouth"),
 * Properties: logic.IntegrationServiceEnvironmentPropertiesResponse{
 * EncryptionConfiguration: interface{}{
 * EncryptionKeyReference: interface{}{
 * KeyName: pulumi.String("testKeyName"),
 * KeyVault: &logic.ResourceReferenceArgs{
 * Id: pulumi.String("/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.KeyVault/vaults/testKeyVault"),
 * },
 * KeyVersion: pulumi.String("13b261d30b984753869902d7f47f4d55"),
 * },
 * },
 * NetworkConfiguration: interface{}{
 * AccessEndpoint: &logic.IntegrationServiceEnvironmentAccessEndpointArgs{
 * Type: pulumi.String("Internal"),
 * },
 * Subnets: logic.ResourceReferenceArray{
 * &logic.ResourceReferenceArgs{
 * Id: pulumi.String("/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s1"),
 * },
 * &logic.ResourceReferenceArgs{
 * Id: pulumi.String("/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s2"),
 * },
 * &logic.ResourceReferenceArgs{
 * Id: pulumi.String("/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s3"),
 * },
 * &logic.ResourceReferenceArgs{
 * Id: pulumi.String("/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s4"),
 * },
 * },
 * },
 * },
 * ResourceGroup: pulumi.String("testResourceGroup"),
 * Sku: &logic.IntegrationServiceEnvironmentSkuArgs{
 * Capacity: pulumi.Int(2),
 * Name: pulumi.String("Premium"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationServiceEnvironment;
 * import com.pulumi.azurenative.logic.IntegrationServiceEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationServiceEnvironment = new IntegrationServiceEnvironment("integrationServiceEnvironment", IntegrationServiceEnvironmentArgs.builder()
 *             .integrationServiceEnvironmentName("testIntegrationServiceEnvironment")
 *             .location("brazilsouth")
 *             .properties(Map.ofEntries(
 *                 Map.entry("encryptionConfiguration", Map.of("encryptionKeyReference", Map.ofEntries(
 *                     Map.entry("keyName", "testKeyName"),
 *                     Map.entry("keyVault", Map.of("id", "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.KeyVault/vaults/testKeyVault")),
 *                     Map.entry("keyVersion", "13b261d30b984753869902d7f47f4d55")
 *                 ))),
 *                 Map.entry("networkConfiguration", Map.ofEntries(
 *                     Map.entry("accessEndpoint", Map.of("type", "Internal")),
 *                     Map.entry("subnets",
 *                         Map.of("id", "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s1"),
 *                         Map.of("id", "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s2"),
 *                         Map.of("id", "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s3"),
 *                         Map.of("id", "/subscriptions/f34b22a3-2202-4fb1-b040-1332bd928c84/resourceGroups/testResourceGroup/providers/Microsoft.Network/virtualNetworks/testVNET/subnets/s4"))
 *                 ))
 *             ))
 *             .resourceGroup("testResourceGroup")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("name", "Premium")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationServiceEnvironment testIntegrationServiceEnvironment /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Logic/integrationServiceEnvironments/{integrationServiceEnvironmentName}
 * ```
 */
public class IntegrationServiceEnvironment internal constructor(
    override val javaResource: com.pulumi.azurenative.logic.IntegrationServiceEnvironment,
) : KotlinCustomResource(javaResource, IntegrationServiceEnvironmentMapper) {
    /**
     * Managed service identity properties.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The integration service environment properties.
     */
    public val properties: Output<IntegrationServiceEnvironmentPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                integrationServiceEnvironmentPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The sku.
     */
    public val sku: Output<IntegrationServiceEnvironmentSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    integrationServiceEnvironmentSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets the resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IntegrationServiceEnvironmentMapper : ResourceMapper<IntegrationServiceEnvironment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.logic.IntegrationServiceEnvironment::class == javaResource::class

    override fun map(javaResource: Resource): IntegrationServiceEnvironment =
        IntegrationServiceEnvironment(
            javaResource as
                com.pulumi.azurenative.logic.IntegrationServiceEnvironment,
        )
}

/**
 * @see [IntegrationServiceEnvironment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IntegrationServiceEnvironment].
 */
public suspend fun integrationServiceEnvironment(
    name: String,
    block: suspend IntegrationServiceEnvironmentResourceBuilder.() -> Unit,
):
    IntegrationServiceEnvironment {
    val builder = IntegrationServiceEnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IntegrationServiceEnvironment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integrationServiceEnvironment(name: String): IntegrationServiceEnvironment {
    val builder = IntegrationServiceEnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
