@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.IntegrationServiceEnvironmentManagedApiArgs.builder
import com.pulumi.azurenative.logic.kotlin.inputs.IntegrationServiceEnvironmentManagedApiDeploymentParametersArgs
import com.pulumi.azurenative.logic.kotlin.inputs.IntegrationServiceEnvironmentManagedApiDeploymentParametersArgsBuilder
import com.pulumi.azurenative.logic.kotlin.inputs.ResourceReferenceArgs
import com.pulumi.azurenative.logic.kotlin.inputs.ResourceReferenceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The integration service environment managed api.
 * Azure REST API version: 2019-05-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * ## Example Usage
 * ### Gets the integration service environment managed Apis
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var integrationServiceEnvironmentManagedApi = new AzureNative.Logic.IntegrationServiceEnvironmentManagedApi("integrationServiceEnvironmentManagedApi", new()
 *     {
 *         ApiName = "servicebus",
 *         IntegrationServiceEnvironmentName = "testIntegrationServiceEnvironment",
 *         Location = "brazilsouth",
 *         ResourceGroup = "testResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logic.NewIntegrationServiceEnvironmentManagedApi(ctx, "integrationServiceEnvironmentManagedApi", &logic.IntegrationServiceEnvironmentManagedApiArgs{
 * 			ApiName:                           pulumi.String("servicebus"),
 * 			IntegrationServiceEnvironmentName: pulumi.String("testIntegrationServiceEnvironment"),
 * 			Location:                          pulumi.String("brazilsouth"),
 * 			ResourceGroup:                     pulumi.String("testResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logic.IntegrationServiceEnvironmentManagedApi;
 * import com.pulumi.azurenative.logic.IntegrationServiceEnvironmentManagedApiArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var integrationServiceEnvironmentManagedApi = new IntegrationServiceEnvironmentManagedApi("integrationServiceEnvironmentManagedApi", IntegrationServiceEnvironmentManagedApiArgs.builder()
 *             .apiName("servicebus")
 *             .integrationServiceEnvironmentName("testIntegrationServiceEnvironment")
 *             .location("brazilsouth")
 *             .resourceGroup("testResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:IntegrationServiceEnvironmentManagedApi servicebus /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Logic/integrationServiceEnvironments/{integrationServiceEnvironmentName}/managedApis/{apiName}
 * ```
 * @property apiName The api name.
 * @property deploymentParameters The integration service environment managed api deployment parameters.
 * @property integrationServiceEnvironment The integration service environment reference.
 * @property integrationServiceEnvironmentName The integration service environment name.
 * @property location The resource location.
 * @property resourceGroup The resource group name.
 * @property tags The resource tags.
 */
public data class IntegrationServiceEnvironmentManagedApiArgs(
    public val apiName: Output<String>? = null,
    public val deploymentParameters:
    Output<IntegrationServiceEnvironmentManagedApiDeploymentParametersArgs>? = null,
    public val integrationServiceEnvironment: Output<ResourceReferenceArgs>? = null,
    public val integrationServiceEnvironmentName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.IntegrationServiceEnvironmentManagedApiArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.IntegrationServiceEnvironmentManagedApiArgs =
        com.pulumi.azurenative.logic.IntegrationServiceEnvironmentManagedApiArgs.builder()
            .apiName(apiName?.applyValue({ args0 -> args0 }))
            .deploymentParameters(
                deploymentParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .integrationServiceEnvironment(
                integrationServiceEnvironment?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .integrationServiceEnvironmentName(
                integrationServiceEnvironmentName?.applyValue({ args0 ->
                    args0
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IntegrationServiceEnvironmentManagedApiArgs].
 */
@PulumiTagMarker
public class IntegrationServiceEnvironmentManagedApiArgsBuilder internal constructor() {
    private var apiName: Output<String>? = null

    private var deploymentParameters:
        Output<IntegrationServiceEnvironmentManagedApiDeploymentParametersArgs>? = null

    private var integrationServiceEnvironment: Output<ResourceReferenceArgs>? = null

    private var integrationServiceEnvironmentName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The api name.
     */
    @JvmName("yhdsgdsvrdkejouf")
    public suspend fun apiName(`value`: Output<String>) {
        this.apiName = value
    }

    /**
     * @param value The integration service environment managed api deployment parameters.
     */
    @JvmName("fynrouxdbtsxnfdo")
    public suspend
    fun deploymentParameters(`value`: Output<IntegrationServiceEnvironmentManagedApiDeploymentParametersArgs>) {
        this.deploymentParameters = value
    }

    /**
     * @param value The integration service environment reference.
     */
    @JvmName("tlekmaynrkicpsuo")
    public suspend fun integrationServiceEnvironment(`value`: Output<ResourceReferenceArgs>) {
        this.integrationServiceEnvironment = value
    }

    /**
     * @param value The integration service environment name.
     */
    @JvmName("lmvfhrwcjrnjmayt")
    public suspend fun integrationServiceEnvironmentName(`value`: Output<String>) {
        this.integrationServiceEnvironmentName = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("qfhexqfieofepryq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("svhmfpybhquxsqoj")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("dvnmssbmhlrtfpie")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The api name.
     */
    @JvmName("htnqqnkaorpjaebv")
    public suspend fun apiName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiName = mapped
    }

    /**
     * @param value The integration service environment managed api deployment parameters.
     */
    @JvmName("vveybrkmvmiksrfs")
    public suspend
    fun deploymentParameters(`value`: IntegrationServiceEnvironmentManagedApiDeploymentParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentParameters = mapped
    }

    /**
     * @param argument The integration service environment managed api deployment parameters.
     */
    @JvmName("vpfkklndpaeabalv")
    public suspend
    fun deploymentParameters(argument: suspend IntegrationServiceEnvironmentManagedApiDeploymentParametersArgsBuilder.() -> Unit) {
        val toBeMapped =
            IntegrationServiceEnvironmentManagedApiDeploymentParametersArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.deploymentParameters = mapped
    }

    /**
     * @param value The integration service environment reference.
     */
    @JvmName("fgcoouvimlxikcmq")
    public suspend fun integrationServiceEnvironment(`value`: ResourceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationServiceEnvironment = mapped
    }

    /**
     * @param argument The integration service environment reference.
     */
    @JvmName("hqrkbnshghkjtdya")
    public suspend
    fun integrationServiceEnvironment(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.integrationServiceEnvironment = mapped
    }

    /**
     * @param value The integration service environment name.
     */
    @JvmName("wnqnnmwbssbdmpsw")
    public suspend fun integrationServiceEnvironmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationServiceEnvironmentName = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("veqjbtvtivxstpye")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("voqcphhrcblngldf")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("bmnrskbxabcxeift")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("euvtdquohiulfabj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IntegrationServiceEnvironmentManagedApiArgs =
        IntegrationServiceEnvironmentManagedApiArgs(
            apiName = apiName,
            deploymentParameters = deploymentParameters,
            integrationServiceEnvironment = integrationServiceEnvironment,
            integrationServiceEnvironmentName = integrationServiceEnvironmentName,
            location = location,
            resourceGroup = resourceGroup,
            tags = tags,
        )
}
