@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin

import com.pulumi.azurenative.logic.WorkflowAccessKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2015-02-01-preview. Prior API version in Azure Native 1.x: 2015-02-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logic:WorkflowAccessKey myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/workflows/{workflowName}/accessKeys/{accessKeyName}
 * ```
 * @property accessKeyName The workflow access key name.
 * @property id Gets or sets the resource id.
 * @property notAfter Gets or sets the not-after time.
 * @property notBefore Gets or sets the not-before time.
 * @property resourceGroupName The resource group name.
 * @property workflowName The workflow name.
 */
public data class WorkflowAccessKeyArgs(
    public val accessKeyName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val notAfter: Output<String>? = null,
    public val notBefore: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workflowName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.WorkflowAccessKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.WorkflowAccessKeyArgs =
        com.pulumi.azurenative.logic.WorkflowAccessKeyArgs.builder()
            .accessKeyName(accessKeyName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .notAfter(notAfter?.applyValue({ args0 -> args0 }))
            .notBefore(notBefore?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workflowName(workflowName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowAccessKeyArgs].
 */
@PulumiTagMarker
public class WorkflowAccessKeyArgsBuilder internal constructor() {
    private var accessKeyName: Output<String>? = null

    private var id: Output<String>? = null

    private var notAfter: Output<String>? = null

    private var notBefore: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workflowName: Output<String>? = null

    /**
     * @param value The workflow access key name.
     */
    @JvmName("ssvtgxbhltwcidpk")
    public suspend fun accessKeyName(`value`: Output<String>) {
        this.accessKeyName = value
    }

    /**
     * @param value Gets or sets the resource id.
     */
    @JvmName("ciqvflsoixvbplij")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Gets or sets the not-after time.
     */
    @JvmName("ptbmhocadosdunhf")
    public suspend fun notAfter(`value`: Output<String>) {
        this.notAfter = value
    }

    /**
     * @param value Gets or sets the not-before time.
     */
    @JvmName("wrudbcdxflrqdjgk")
    public suspend fun notBefore(`value`: Output<String>) {
        this.notBefore = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("vhmrinpxtsjjaxol")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The workflow name.
     */
    @JvmName("aafqbbhrlqqqsrbf")
    public suspend fun workflowName(`value`: Output<String>) {
        this.workflowName = value
    }

    /**
     * @param value The workflow access key name.
     */
    @JvmName("uyufiopkgttggspp")
    public suspend fun accessKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKeyName = mapped
    }

    /**
     * @param value Gets or sets the resource id.
     */
    @JvmName("gtyxawnloqfngikw")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Gets or sets the not-after time.
     */
    @JvmName("rolkolxosqikooqe")
    public suspend fun notAfter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notAfter = mapped
    }

    /**
     * @param value Gets or sets the not-before time.
     */
    @JvmName("mxkkoedtayqxqiow")
    public suspend fun notBefore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notBefore = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("pwooanriuqldpons")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The workflow name.
     */
    @JvmName("cugmnwjbixbchmle")
    public suspend fun workflowName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workflowName = mapped
    }

    internal fun build(): WorkflowAccessKeyArgs = WorkflowAccessKeyArgs(
        accessKeyName = accessKeyName,
        id = id,
        notAfter = notAfter,
        notBefore = notBefore,
        resourceGroupName = resourceGroupName,
        workflowName = workflowName,
    )
}
