@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of managed service identity. The type 'SystemAssigned' includes an implicitly created identity. The type 'None' will remove any identities from the resource.
 */
public enum class ManagedServiceIdentityType(
    public val javaValue: com.pulumi.azurenative.logic.enums.ManagedServiceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.logic.enums.ManagedServiceIdentityType> {
    SystemAssigned(com.pulumi.azurenative.logic.enums.ManagedServiceIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.logic.enums.ManagedServiceIdentityType.UserAssigned),
    None(com.pulumi.azurenative.logic.enums.ManagedServiceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.logic.enums.ManagedServiceIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.enums.ManagedServiceIdentityType):
            ManagedServiceIdentityType =
            ManagedServiceIdentityType.values().first { it.javaValue == javaType }
    }
}
