@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.AS2MdnSettingsArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.HashingAlgorithm
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The AS2 agreement mdn settings.
 * @property dispositionNotificationTo The disposition notification to header value.
 * @property mdnText The MDN text.
 * @property micHashingAlgorithm The signing or hashing algorithm.
 * @property needMDN The value indicating whether to send or request a MDN.
 * @property receiptDeliveryUrl The receipt delivery URL.
 * @property sendInboundMDNToMessageBox The value indicating whether to send inbound MDN to message box.
 * @property sendMDNAsynchronously The value indicating whether to send the asynchronous MDN.
 * @property signMDN The value indicating whether the MDN needs to be signed or not.
 * @property signOutboundMDNIfOptional The value indicating whether to sign the outbound MDN if optional.
 */
public data class AS2MdnSettingsArgs(
    public val dispositionNotificationTo: Output<String>? = null,
    public val mdnText: Output<String>? = null,
    public val micHashingAlgorithm: Output<Either<String, HashingAlgorithm>>,
    public val needMDN: Output<Boolean>,
    public val receiptDeliveryUrl: Output<String>? = null,
    public val sendInboundMDNToMessageBox: Output<Boolean>,
    public val sendMDNAsynchronously: Output<Boolean>,
    public val signMDN: Output<Boolean>,
    public val signOutboundMDNIfOptional: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.AS2MdnSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.AS2MdnSettingsArgs =
        com.pulumi.azurenative.logic.inputs.AS2MdnSettingsArgs.builder()
            .dispositionNotificationTo(dispositionNotificationTo?.applyValue({ args0 -> args0 }))
            .mdnText(mdnText?.applyValue({ args0 -> args0 }))
            .micHashingAlgorithm(
                micHashingAlgorithm.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .needMDN(needMDN.applyValue({ args0 -> args0 }))
            .receiptDeliveryUrl(receiptDeliveryUrl?.applyValue({ args0 -> args0 }))
            .sendInboundMDNToMessageBox(sendInboundMDNToMessageBox.applyValue({ args0 -> args0 }))
            .sendMDNAsynchronously(sendMDNAsynchronously.applyValue({ args0 -> args0 }))
            .signMDN(signMDN.applyValue({ args0 -> args0 }))
            .signOutboundMDNIfOptional(signOutboundMDNIfOptional.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AS2MdnSettingsArgs].
 */
@PulumiTagMarker
public class AS2MdnSettingsArgsBuilder internal constructor() {
    private var dispositionNotificationTo: Output<String>? = null

    private var mdnText: Output<String>? = null

    private var micHashingAlgorithm: Output<Either<String, HashingAlgorithm>>? = null

    private var needMDN: Output<Boolean>? = null

    private var receiptDeliveryUrl: Output<String>? = null

    private var sendInboundMDNToMessageBox: Output<Boolean>? = null

    private var sendMDNAsynchronously: Output<Boolean>? = null

    private var signMDN: Output<Boolean>? = null

    private var signOutboundMDNIfOptional: Output<Boolean>? = null

    /**
     * @param value The disposition notification to header value.
     */
    @JvmName("ssjussgcqrixniva")
    public suspend fun dispositionNotificationTo(`value`: Output<String>) {
        this.dispositionNotificationTo = value
    }

    /**
     * @param value The MDN text.
     */
    @JvmName("cxpmjojcwqvivaqp")
    public suspend fun mdnText(`value`: Output<String>) {
        this.mdnText = value
    }

    /**
     * @param value The signing or hashing algorithm.
     */
    @JvmName("bnrxlfpqpsnlxgwa")
    public suspend fun micHashingAlgorithm(`value`: Output<Either<String, HashingAlgorithm>>) {
        this.micHashingAlgorithm = value
    }

    /**
     * @param value The value indicating whether to send or request a MDN.
     */
    @JvmName("ctobebluknqvxbtf")
    public suspend fun needMDN(`value`: Output<Boolean>) {
        this.needMDN = value
    }

    /**
     * @param value The receipt delivery URL.
     */
    @JvmName("gujlryrwievwsqlt")
    public suspend fun receiptDeliveryUrl(`value`: Output<String>) {
        this.receiptDeliveryUrl = value
    }

    /**
     * @param value The value indicating whether to send inbound MDN to message box.
     */
    @JvmName("iqdnyvkuwlnyfjeq")
    public suspend fun sendInboundMDNToMessageBox(`value`: Output<Boolean>) {
        this.sendInboundMDNToMessageBox = value
    }

    /**
     * @param value The value indicating whether to send the asynchronous MDN.
     */
    @JvmName("fyibxoxsjvoipsun")
    public suspend fun sendMDNAsynchronously(`value`: Output<Boolean>) {
        this.sendMDNAsynchronously = value
    }

    /**
     * @param value The value indicating whether the MDN needs to be signed or not.
     */
    @JvmName("vsxjagvbnrapitxw")
    public suspend fun signMDN(`value`: Output<Boolean>) {
        this.signMDN = value
    }

    /**
     * @param value The value indicating whether to sign the outbound MDN if optional.
     */
    @JvmName("onarkbmllsywffoe")
    public suspend fun signOutboundMDNIfOptional(`value`: Output<Boolean>) {
        this.signOutboundMDNIfOptional = value
    }

    /**
     * @param value The disposition notification to header value.
     */
    @JvmName("biovuaokvebyctux")
    public suspend fun dispositionNotificationTo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dispositionNotificationTo = mapped
    }

    /**
     * @param value The MDN text.
     */
    @JvmName("nrxpdpiwjylafvga")
    public suspend fun mdnText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mdnText = mapped
    }

    /**
     * @param value The signing or hashing algorithm.
     */
    @JvmName("rqwfamhexvgfhcuc")
    public suspend fun micHashingAlgorithm(`value`: Either<String, HashingAlgorithm>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.micHashingAlgorithm = mapped
    }

    /**
     * @param value The signing or hashing algorithm.
     */
    @JvmName("qpdcgltsnxpxsytx")
    public fun micHashingAlgorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HashingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.micHashingAlgorithm = mapped
    }

    /**
     * @param value The signing or hashing algorithm.
     */
    @JvmName("wcbjyhfuoyxgtpgy")
    public fun micHashingAlgorithm(`value`: HashingAlgorithm) {
        val toBeMapped = Either.ofRight<String, HashingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.micHashingAlgorithm = mapped
    }

    /**
     * @param value The value indicating whether to send or request a MDN.
     */
    @JvmName("tbbollkcrfaqdfcb")
    public suspend fun needMDN(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.needMDN = mapped
    }

    /**
     * @param value The receipt delivery URL.
     */
    @JvmName("fhwscquhkknwvtre")
    public suspend fun receiptDeliveryUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.receiptDeliveryUrl = mapped
    }

    /**
     * @param value The value indicating whether to send inbound MDN to message box.
     */
    @JvmName("djnxbnknkpvniayn")
    public suspend fun sendInboundMDNToMessageBox(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sendInboundMDNToMessageBox = mapped
    }

    /**
     * @param value The value indicating whether to send the asynchronous MDN.
     */
    @JvmName("tuvetmravanycojl")
    public suspend fun sendMDNAsynchronously(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sendMDNAsynchronously = mapped
    }

    /**
     * @param value The value indicating whether the MDN needs to be signed or not.
     */
    @JvmName("hvagtxoxfvribtgw")
    public suspend fun signMDN(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.signMDN = mapped
    }

    /**
     * @param value The value indicating whether to sign the outbound MDN if optional.
     */
    @JvmName("nahkyecvisxrmmbh")
    public suspend fun signOutboundMDNIfOptional(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.signOutboundMDNIfOptional = mapped
    }

    internal fun build(): AS2MdnSettingsArgs = AS2MdnSettingsArgs(
        dispositionNotificationTo = dispositionNotificationTo,
        mdnText = mdnText,
        micHashingAlgorithm = micHashingAlgorithm ?: throw PulumiNullFieldException("micHashingAlgorithm"),
        needMDN = needMDN ?: throw PulumiNullFieldException("needMDN"),
        receiptDeliveryUrl = receiptDeliveryUrl,
        sendInboundMDNToMessageBox = sendInboundMDNToMessageBox ?: throw
            PulumiNullFieldException("sendInboundMDNToMessageBox"),
        sendMDNAsynchronously = sendMDNAsynchronously ?: throw
            PulumiNullFieldException("sendMDNAsynchronously"),
        signMDN = signMDN ?: throw PulumiNullFieldException("signMDN"),
        signOutboundMDNIfOptional = signOutboundMDNIfOptional ?: throw
            PulumiNullFieldException("signOutboundMDNIfOptional"),
    )
}
