@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.EdifactEnvelopeSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Edifact agreement envelope settings.
 * @property applicationReferenceId The application reference id.
 * @property applyDelimiterStringAdvice The value indicating whether to apply delimiter string advice.
 * @property communicationAgreementId The communication agreement id.
 * @property createGroupingSegments The value indicating whether to create grouping segments.
 * @property enableDefaultGroupHeaders The value indicating whether to enable default group headers.
 * @property functionalGroupId The functional group id.
 * @property groupApplicationPassword The group application password.
 * @property groupApplicationReceiverId The group application receiver id.
 * @property groupApplicationReceiverQualifier The group application receiver qualifier.
 * @property groupApplicationSenderId The group application sender id.
 * @property groupApplicationSenderQualifier The group application sender qualifier.
 * @property groupAssociationAssignedCode The group association assigned code.
 * @property groupControlNumberLowerBound The group control number lower bound.
 * @property groupControlNumberPrefix The group control number prefix.
 * @property groupControlNumberSuffix The group control number suffix.
 * @property groupControlNumberUpperBound The group control number upper bound.
 * @property groupControllingAgencyCode The group controlling agency code.
 * @property groupMessageRelease The group message release.
 * @property groupMessageVersion The group message version.
 * @property interchangeControlNumberLowerBound The interchange control number lower bound.
 * @property interchangeControlNumberPrefix The interchange control number prefix.
 * @property interchangeControlNumberSuffix The interchange control number suffix.
 * @property interchangeControlNumberUpperBound The interchange control number upper bound.
 * @property isTestInterchange The value indicating whether the message is a test interchange.
 * @property overwriteExistingTransactionSetControlNumber The value indicating whether to overwrite existing transaction set control number.
 * @property processingPriorityCode The processing priority code.
 * @property receiverInternalIdentification The receiver internal identification.
 * @property receiverInternalSubIdentification The receiver internal sub identification.
 * @property receiverReverseRoutingAddress The receiver reverse routing address.
 * @property recipientReferencePasswordQualifier The recipient reference password qualifier.
 * @property recipientReferencePasswordValue The recipient reference password value.
 * @property rolloverGroupControlNumber The value indicating whether to rollover group control number.
 * @property rolloverInterchangeControlNumber The value indicating whether to rollover interchange control number.
 * @property rolloverTransactionSetControlNumber The value indicating whether to rollover transaction set control number.
 * @property senderInternalIdentification The sender internal identification.
 * @property senderInternalSubIdentification The sender internal sub identification.
 * @property senderReverseRoutingAddress The sender reverse routing address.
 * @property transactionSetControlNumberLowerBound The transaction set control number lower bound.
 * @property transactionSetControlNumberPrefix The transaction set control number prefix.
 * @property transactionSetControlNumberSuffix The transaction set control number suffix.
 * @property transactionSetControlNumberUpperBound The transaction set control number upper bound.
 */
public data class EdifactEnvelopeSettingsArgs(
    public val applicationReferenceId: Output<String>? = null,
    public val applyDelimiterStringAdvice: Output<Boolean>,
    public val communicationAgreementId: Output<String>? = null,
    public val createGroupingSegments: Output<Boolean>,
    public val enableDefaultGroupHeaders: Output<Boolean>,
    public val functionalGroupId: Output<String>? = null,
    public val groupApplicationPassword: Output<String>? = null,
    public val groupApplicationReceiverId: Output<String>? = null,
    public val groupApplicationReceiverQualifier: Output<String>? = null,
    public val groupApplicationSenderId: Output<String>? = null,
    public val groupApplicationSenderQualifier: Output<String>? = null,
    public val groupAssociationAssignedCode: Output<String>? = null,
    public val groupControlNumberLowerBound: Output<Double>,
    public val groupControlNumberPrefix: Output<String>? = null,
    public val groupControlNumberSuffix: Output<String>? = null,
    public val groupControlNumberUpperBound: Output<Double>,
    public val groupControllingAgencyCode: Output<String>? = null,
    public val groupMessageRelease: Output<String>? = null,
    public val groupMessageVersion: Output<String>? = null,
    public val interchangeControlNumberLowerBound: Output<Double>,
    public val interchangeControlNumberPrefix: Output<String>? = null,
    public val interchangeControlNumberSuffix: Output<String>? = null,
    public val interchangeControlNumberUpperBound: Output<Double>,
    public val isTestInterchange: Output<Boolean>,
    public val overwriteExistingTransactionSetControlNumber: Output<Boolean>,
    public val processingPriorityCode: Output<String>? = null,
    public val receiverInternalIdentification: Output<String>? = null,
    public val receiverInternalSubIdentification: Output<String>? = null,
    public val receiverReverseRoutingAddress: Output<String>? = null,
    public val recipientReferencePasswordQualifier: Output<String>? = null,
    public val recipientReferencePasswordValue: Output<String>? = null,
    public val rolloverGroupControlNumber: Output<Boolean>,
    public val rolloverInterchangeControlNumber: Output<Boolean>,
    public val rolloverTransactionSetControlNumber: Output<Boolean>,
    public val senderInternalIdentification: Output<String>? = null,
    public val senderInternalSubIdentification: Output<String>? = null,
    public val senderReverseRoutingAddress: Output<String>? = null,
    public val transactionSetControlNumberLowerBound: Output<Double>,
    public val transactionSetControlNumberPrefix: Output<String>? = null,
    public val transactionSetControlNumberSuffix: Output<String>? = null,
    public val transactionSetControlNumberUpperBound: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.EdifactEnvelopeSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.EdifactEnvelopeSettingsArgs =
        com.pulumi.azurenative.logic.inputs.EdifactEnvelopeSettingsArgs.builder()
            .applicationReferenceId(applicationReferenceId?.applyValue({ args0 -> args0 }))
            .applyDelimiterStringAdvice(applyDelimiterStringAdvice.applyValue({ args0 -> args0 }))
            .communicationAgreementId(communicationAgreementId?.applyValue({ args0 -> args0 }))
            .createGroupingSegments(createGroupingSegments.applyValue({ args0 -> args0 }))
            .enableDefaultGroupHeaders(enableDefaultGroupHeaders.applyValue({ args0 -> args0 }))
            .functionalGroupId(functionalGroupId?.applyValue({ args0 -> args0 }))
            .groupApplicationPassword(groupApplicationPassword?.applyValue({ args0 -> args0 }))
            .groupApplicationReceiverId(groupApplicationReceiverId?.applyValue({ args0 -> args0 }))
            .groupApplicationReceiverQualifier(
                groupApplicationReceiverQualifier?.applyValue({ args0 ->
                    args0
                }),
            )
            .groupApplicationSenderId(groupApplicationSenderId?.applyValue({ args0 -> args0 }))
            .groupApplicationSenderQualifier(groupApplicationSenderQualifier?.applyValue({ args0 -> args0 }))
            .groupAssociationAssignedCode(groupAssociationAssignedCode?.applyValue({ args0 -> args0 }))
            .groupControlNumberLowerBound(groupControlNumberLowerBound.applyValue({ args0 -> args0 }))
            .groupControlNumberPrefix(groupControlNumberPrefix?.applyValue({ args0 -> args0 }))
            .groupControlNumberSuffix(groupControlNumberSuffix?.applyValue({ args0 -> args0 }))
            .groupControlNumberUpperBound(groupControlNumberUpperBound.applyValue({ args0 -> args0 }))
            .groupControllingAgencyCode(groupControllingAgencyCode?.applyValue({ args0 -> args0 }))
            .groupMessageRelease(groupMessageRelease?.applyValue({ args0 -> args0 }))
            .groupMessageVersion(groupMessageVersion?.applyValue({ args0 -> args0 }))
            .interchangeControlNumberLowerBound(
                interchangeControlNumberLowerBound.applyValue({ args0 ->
                    args0
                }),
            )
            .interchangeControlNumberPrefix(interchangeControlNumberPrefix?.applyValue({ args0 -> args0 }))
            .interchangeControlNumberSuffix(interchangeControlNumberSuffix?.applyValue({ args0 -> args0 }))
            .interchangeControlNumberUpperBound(
                interchangeControlNumberUpperBound.applyValue({ args0 ->
                    args0
                }),
            )
            .isTestInterchange(isTestInterchange.applyValue({ args0 -> args0 }))
            .overwriteExistingTransactionSetControlNumber(
                overwriteExistingTransactionSetControlNumber.applyValue({ args0 ->
                    args0
                }),
            )
            .processingPriorityCode(processingPriorityCode?.applyValue({ args0 -> args0 }))
            .receiverInternalIdentification(receiverInternalIdentification?.applyValue({ args0 -> args0 }))
            .receiverInternalSubIdentification(
                receiverInternalSubIdentification?.applyValue({ args0 ->
                    args0
                }),
            )
            .receiverReverseRoutingAddress(receiverReverseRoutingAddress?.applyValue({ args0 -> args0 }))
            .recipientReferencePasswordQualifier(
                recipientReferencePasswordQualifier?.applyValue({ args0 ->
                    args0
                }),
            )
            .recipientReferencePasswordValue(recipientReferencePasswordValue?.applyValue({ args0 -> args0 }))
            .rolloverGroupControlNumber(rolloverGroupControlNumber.applyValue({ args0 -> args0 }))
            .rolloverInterchangeControlNumber(rolloverInterchangeControlNumber.applyValue({ args0 -> args0 }))
            .rolloverTransactionSetControlNumber(
                rolloverTransactionSetControlNumber.applyValue({ args0 ->
                    args0
                }),
            )
            .senderInternalIdentification(senderInternalIdentification?.applyValue({ args0 -> args0 }))
            .senderInternalSubIdentification(senderInternalSubIdentification?.applyValue({ args0 -> args0 }))
            .senderReverseRoutingAddress(senderReverseRoutingAddress?.applyValue({ args0 -> args0 }))
            .transactionSetControlNumberLowerBound(
                transactionSetControlNumberLowerBound.applyValue({ args0 ->
                    args0
                }),
            )
            .transactionSetControlNumberPrefix(
                transactionSetControlNumberPrefix?.applyValue({ args0 ->
                    args0
                }),
            )
            .transactionSetControlNumberSuffix(
                transactionSetControlNumberSuffix?.applyValue({ args0 ->
                    args0
                }),
            )
            .transactionSetControlNumberUpperBound(
                transactionSetControlNumberUpperBound.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [EdifactEnvelopeSettingsArgs].
 */
@PulumiTagMarker
public class EdifactEnvelopeSettingsArgsBuilder internal constructor() {
    private var applicationReferenceId: Output<String>? = null

    private var applyDelimiterStringAdvice: Output<Boolean>? = null

    private var communicationAgreementId: Output<String>? = null

    private var createGroupingSegments: Output<Boolean>? = null

    private var enableDefaultGroupHeaders: Output<Boolean>? = null

    private var functionalGroupId: Output<String>? = null

    private var groupApplicationPassword: Output<String>? = null

    private var groupApplicationReceiverId: Output<String>? = null

    private var groupApplicationReceiverQualifier: Output<String>? = null

    private var groupApplicationSenderId: Output<String>? = null

    private var groupApplicationSenderQualifier: Output<String>? = null

    private var groupAssociationAssignedCode: Output<String>? = null

    private var groupControlNumberLowerBound: Output<Double>? = null

    private var groupControlNumberPrefix: Output<String>? = null

    private var groupControlNumberSuffix: Output<String>? = null

    private var groupControlNumberUpperBound: Output<Double>? = null

    private var groupControllingAgencyCode: Output<String>? = null

    private var groupMessageRelease: Output<String>? = null

    private var groupMessageVersion: Output<String>? = null

    private var interchangeControlNumberLowerBound: Output<Double>? = null

    private var interchangeControlNumberPrefix: Output<String>? = null

    private var interchangeControlNumberSuffix: Output<String>? = null

    private var interchangeControlNumberUpperBound: Output<Double>? = null

    private var isTestInterchange: Output<Boolean>? = null

    private var overwriteExistingTransactionSetControlNumber: Output<Boolean>? = null

    private var processingPriorityCode: Output<String>? = null

    private var receiverInternalIdentification: Output<String>? = null

    private var receiverInternalSubIdentification: Output<String>? = null

    private var receiverReverseRoutingAddress: Output<String>? = null

    private var recipientReferencePasswordQualifier: Output<String>? = null

    private var recipientReferencePasswordValue: Output<String>? = null

    private var rolloverGroupControlNumber: Output<Boolean>? = null

    private var rolloverInterchangeControlNumber: Output<Boolean>? = null

    private var rolloverTransactionSetControlNumber: Output<Boolean>? = null

    private var senderInternalIdentification: Output<String>? = null

    private var senderInternalSubIdentification: Output<String>? = null

    private var senderReverseRoutingAddress: Output<String>? = null

    private var transactionSetControlNumberLowerBound: Output<Double>? = null

    private var transactionSetControlNumberPrefix: Output<String>? = null

    private var transactionSetControlNumberSuffix: Output<String>? = null

    private var transactionSetControlNumberUpperBound: Output<Double>? = null

    /**
     * @param value The application reference id.
     */
    @JvmName("saoykijkgkgbgvoe")
    public suspend fun applicationReferenceId(`value`: Output<String>) {
        this.applicationReferenceId = value
    }

    /**
     * @param value The value indicating whether to apply delimiter string advice.
     */
    @JvmName("kmujlbbvfujhahmy")
    public suspend fun applyDelimiterStringAdvice(`value`: Output<Boolean>) {
        this.applyDelimiterStringAdvice = value
    }

    /**
     * @param value The communication agreement id.
     */
    @JvmName("jpjixnpdfawwjjmh")
    public suspend fun communicationAgreementId(`value`: Output<String>) {
        this.communicationAgreementId = value
    }

    /**
     * @param value The value indicating whether to create grouping segments.
     */
    @JvmName("ctgspgtxwxqejigd")
    public suspend fun createGroupingSegments(`value`: Output<Boolean>) {
        this.createGroupingSegments = value
    }

    /**
     * @param value The value indicating whether to enable default group headers.
     */
    @JvmName("uxbgxvdfppdyoyar")
    public suspend fun enableDefaultGroupHeaders(`value`: Output<Boolean>) {
        this.enableDefaultGroupHeaders = value
    }

    /**
     * @param value The functional group id.
     */
    @JvmName("adpjltqhpbxgtecc")
    public suspend fun functionalGroupId(`value`: Output<String>) {
        this.functionalGroupId = value
    }

    /**
     * @param value The group application password.
     */
    @JvmName("tdvutxseyrdrsswy")
    public suspend fun groupApplicationPassword(`value`: Output<String>) {
        this.groupApplicationPassword = value
    }

    /**
     * @param value The group application receiver id.
     */
    @JvmName("vcoyrlirseapruwl")
    public suspend fun groupApplicationReceiverId(`value`: Output<String>) {
        this.groupApplicationReceiverId = value
    }

    /**
     * @param value The group application receiver qualifier.
     */
    @JvmName("hraajvhiovrqcmcr")
    public suspend fun groupApplicationReceiverQualifier(`value`: Output<String>) {
        this.groupApplicationReceiverQualifier = value
    }

    /**
     * @param value The group application sender id.
     */
    @JvmName("ijlmosenpaoinvos")
    public suspend fun groupApplicationSenderId(`value`: Output<String>) {
        this.groupApplicationSenderId = value
    }

    /**
     * @param value The group application sender qualifier.
     */
    @JvmName("xarbcndlryssmcff")
    public suspend fun groupApplicationSenderQualifier(`value`: Output<String>) {
        this.groupApplicationSenderQualifier = value
    }

    /**
     * @param value The group association assigned code.
     */
    @JvmName("nwydocwtmavmdlnb")
    public suspend fun groupAssociationAssignedCode(`value`: Output<String>) {
        this.groupAssociationAssignedCode = value
    }

    /**
     * @param value The group control number lower bound.
     */
    @JvmName("mkyxxiptnflqunvx")
    public suspend fun groupControlNumberLowerBound(`value`: Output<Double>) {
        this.groupControlNumberLowerBound = value
    }

    /**
     * @param value The group control number prefix.
     */
    @JvmName("lfkcliqjaqeuwgxx")
    public suspend fun groupControlNumberPrefix(`value`: Output<String>) {
        this.groupControlNumberPrefix = value
    }

    /**
     * @param value The group control number suffix.
     */
    @JvmName("uqeijqllawwmmlag")
    public suspend fun groupControlNumberSuffix(`value`: Output<String>) {
        this.groupControlNumberSuffix = value
    }

    /**
     * @param value The group control number upper bound.
     */
    @JvmName("pufprnuqygwcsiqu")
    public suspend fun groupControlNumberUpperBound(`value`: Output<Double>) {
        this.groupControlNumberUpperBound = value
    }

    /**
     * @param value The group controlling agency code.
     */
    @JvmName("whcghxeoigblgdgr")
    public suspend fun groupControllingAgencyCode(`value`: Output<String>) {
        this.groupControllingAgencyCode = value
    }

    /**
     * @param value The group message release.
     */
    @JvmName("vtxsbkwtsbswectt")
    public suspend fun groupMessageRelease(`value`: Output<String>) {
        this.groupMessageRelease = value
    }

    /**
     * @param value The group message version.
     */
    @JvmName("sagunnlnctigcjfa")
    public suspend fun groupMessageVersion(`value`: Output<String>) {
        this.groupMessageVersion = value
    }

    /**
     * @param value The interchange control number lower bound.
     */
    @JvmName("wgkbjlwpfhqyemgu")
    public suspend fun interchangeControlNumberLowerBound(`value`: Output<Double>) {
        this.interchangeControlNumberLowerBound = value
    }

    /**
     * @param value The interchange control number prefix.
     */
    @JvmName("cwnrulsxwotspjrx")
    public suspend fun interchangeControlNumberPrefix(`value`: Output<String>) {
        this.interchangeControlNumberPrefix = value
    }

    /**
     * @param value The interchange control number suffix.
     */
    @JvmName("qoovirqjqhpogunj")
    public suspend fun interchangeControlNumberSuffix(`value`: Output<String>) {
        this.interchangeControlNumberSuffix = value
    }

    /**
     * @param value The interchange control number upper bound.
     */
    @JvmName("uomwtbusvukhfhbf")
    public suspend fun interchangeControlNumberUpperBound(`value`: Output<Double>) {
        this.interchangeControlNumberUpperBound = value
    }

    /**
     * @param value The value indicating whether the message is a test interchange.
     */
    @JvmName("twlplcmauaaxaloy")
    public suspend fun isTestInterchange(`value`: Output<Boolean>) {
        this.isTestInterchange = value
    }

    /**
     * @param value The value indicating whether to overwrite existing transaction set control number.
     */
    @JvmName("olsyoyvhoprgsomp")
    public suspend fun overwriteExistingTransactionSetControlNumber(`value`: Output<Boolean>) {
        this.overwriteExistingTransactionSetControlNumber = value
    }

    /**
     * @param value The processing priority code.
     */
    @JvmName("xyggiucudwouabju")
    public suspend fun processingPriorityCode(`value`: Output<String>) {
        this.processingPriorityCode = value
    }

    /**
     * @param value The receiver internal identification.
     */
    @JvmName("wsliufjgdpblkgds")
    public suspend fun receiverInternalIdentification(`value`: Output<String>) {
        this.receiverInternalIdentification = value
    }

    /**
     * @param value The receiver internal sub identification.
     */
    @JvmName("fbacobtdiwhurfnr")
    public suspend fun receiverInternalSubIdentification(`value`: Output<String>) {
        this.receiverInternalSubIdentification = value
    }

    /**
     * @param value The receiver reverse routing address.
     */
    @JvmName("bnxfeunpappafgky")
    public suspend fun receiverReverseRoutingAddress(`value`: Output<String>) {
        this.receiverReverseRoutingAddress = value
    }

    /**
     * @param value The recipient reference password qualifier.
     */
    @JvmName("wvpwrgbqgxjuskye")
    public suspend fun recipientReferencePasswordQualifier(`value`: Output<String>) {
        this.recipientReferencePasswordQualifier = value
    }

    /**
     * @param value The recipient reference password value.
     */
    @JvmName("sjcfqtmqqjwxwybc")
    public suspend fun recipientReferencePasswordValue(`value`: Output<String>) {
        this.recipientReferencePasswordValue = value
    }

    /**
     * @param value The value indicating whether to rollover group control number.
     */
    @JvmName("btxrdpayvkfimmpq")
    public suspend fun rolloverGroupControlNumber(`value`: Output<Boolean>) {
        this.rolloverGroupControlNumber = value
    }

    /**
     * @param value The value indicating whether to rollover interchange control number.
     */
    @JvmName("iahlqnnfnkntaoho")
    public suspend fun rolloverInterchangeControlNumber(`value`: Output<Boolean>) {
        this.rolloverInterchangeControlNumber = value
    }

    /**
     * @param value The value indicating whether to rollover transaction set control number.
     */
    @JvmName("qphwjxorlmvpwiud")
    public suspend fun rolloverTransactionSetControlNumber(`value`: Output<Boolean>) {
        this.rolloverTransactionSetControlNumber = value
    }

    /**
     * @param value The sender internal identification.
     */
    @JvmName("hixbimvsciapcrbn")
    public suspend fun senderInternalIdentification(`value`: Output<String>) {
        this.senderInternalIdentification = value
    }

    /**
     * @param value The sender internal sub identification.
     */
    @JvmName("eamrfepmtdamtpnq")
    public suspend fun senderInternalSubIdentification(`value`: Output<String>) {
        this.senderInternalSubIdentification = value
    }

    /**
     * @param value The sender reverse routing address.
     */
    @JvmName("bfjpaibdtmxlsefi")
    public suspend fun senderReverseRoutingAddress(`value`: Output<String>) {
        this.senderReverseRoutingAddress = value
    }

    /**
     * @param value The transaction set control number lower bound.
     */
    @JvmName("ffghjmxngpygjftj")
    public suspend fun transactionSetControlNumberLowerBound(`value`: Output<Double>) {
        this.transactionSetControlNumberLowerBound = value
    }

    /**
     * @param value The transaction set control number prefix.
     */
    @JvmName("qovlpyrjdrsdvmhm")
    public suspend fun transactionSetControlNumberPrefix(`value`: Output<String>) {
        this.transactionSetControlNumberPrefix = value
    }

    /**
     * @param value The transaction set control number suffix.
     */
    @JvmName("kqdferopcpdsamsp")
    public suspend fun transactionSetControlNumberSuffix(`value`: Output<String>) {
        this.transactionSetControlNumberSuffix = value
    }

    /**
     * @param value The transaction set control number upper bound.
     */
    @JvmName("mhthymjayryheuio")
    public suspend fun transactionSetControlNumberUpperBound(`value`: Output<Double>) {
        this.transactionSetControlNumberUpperBound = value
    }

    /**
     * @param value The application reference id.
     */
    @JvmName("ucbyslhyulcjtafc")
    public suspend fun applicationReferenceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationReferenceId = mapped
    }

    /**
     * @param value The value indicating whether to apply delimiter string advice.
     */
    @JvmName("huwxkwyoifnyjoto")
    public suspend fun applyDelimiterStringAdvice(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applyDelimiterStringAdvice = mapped
    }

    /**
     * @param value The communication agreement id.
     */
    @JvmName("yoockhafvgcqwomq")
    public suspend fun communicationAgreementId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.communicationAgreementId = mapped
    }

    /**
     * @param value The value indicating whether to create grouping segments.
     */
    @JvmName("xxnucxiwlbrwnkxx")
    public suspend fun createGroupingSegments(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createGroupingSegments = mapped
    }

    /**
     * @param value The value indicating whether to enable default group headers.
     */
    @JvmName("bvxdabduoymverqi")
    public suspend fun enableDefaultGroupHeaders(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableDefaultGroupHeaders = mapped
    }

    /**
     * @param value The functional group id.
     */
    @JvmName("ahomwljhkwpcmspt")
    public suspend fun functionalGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionalGroupId = mapped
    }

    /**
     * @param value The group application password.
     */
    @JvmName("goavsakdpuhlayhr")
    public suspend fun groupApplicationPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupApplicationPassword = mapped
    }

    /**
     * @param value The group application receiver id.
     */
    @JvmName("uxnxylttlectdxps")
    public suspend fun groupApplicationReceiverId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupApplicationReceiverId = mapped
    }

    /**
     * @param value The group application receiver qualifier.
     */
    @JvmName("akkswyylpohdfidx")
    public suspend fun groupApplicationReceiverQualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupApplicationReceiverQualifier = mapped
    }

    /**
     * @param value The group application sender id.
     */
    @JvmName("ntjudrutuuiinbar")
    public suspend fun groupApplicationSenderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupApplicationSenderId = mapped
    }

    /**
     * @param value The group application sender qualifier.
     */
    @JvmName("jougqjekrpvqegmk")
    public suspend fun groupApplicationSenderQualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupApplicationSenderQualifier = mapped
    }

    /**
     * @param value The group association assigned code.
     */
    @JvmName("xmxywoydxqqklpcq")
    public suspend fun groupAssociationAssignedCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupAssociationAssignedCode = mapped
    }

    /**
     * @param value The group control number lower bound.
     */
    @JvmName("vckhdvnuaedgurgu")
    public suspend fun groupControlNumberLowerBound(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupControlNumberLowerBound = mapped
    }

    /**
     * @param value The group control number prefix.
     */
    @JvmName("pwkwciephkiswhwy")
    public suspend fun groupControlNumberPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupControlNumberPrefix = mapped
    }

    /**
     * @param value The group control number suffix.
     */
    @JvmName("xxhpfdthkcucuuxi")
    public suspend fun groupControlNumberSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupControlNumberSuffix = mapped
    }

    /**
     * @param value The group control number upper bound.
     */
    @JvmName("nvulxyasfcccraug")
    public suspend fun groupControlNumberUpperBound(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupControlNumberUpperBound = mapped
    }

    /**
     * @param value The group controlling agency code.
     */
    @JvmName("bdonldgcffajduwi")
    public suspend fun groupControllingAgencyCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupControllingAgencyCode = mapped
    }

    /**
     * @param value The group message release.
     */
    @JvmName("jtjreacagxudofqx")
    public suspend fun groupMessageRelease(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupMessageRelease = mapped
    }

    /**
     * @param value The group message version.
     */
    @JvmName("mjlbqcsysymkwmgh")
    public suspend fun groupMessageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupMessageVersion = mapped
    }

    /**
     * @param value The interchange control number lower bound.
     */
    @JvmName("dswukaocrevoggyh")
    public suspend fun interchangeControlNumberLowerBound(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interchangeControlNumberLowerBound = mapped
    }

    /**
     * @param value The interchange control number prefix.
     */
    @JvmName("cpehdtsamuqkjcnw")
    public suspend fun interchangeControlNumberPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interchangeControlNumberPrefix = mapped
    }

    /**
     * @param value The interchange control number suffix.
     */
    @JvmName("qumhheehgsjbynsk")
    public suspend fun interchangeControlNumberSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interchangeControlNumberSuffix = mapped
    }

    /**
     * @param value The interchange control number upper bound.
     */
    @JvmName("uonwginradvncfld")
    public suspend fun interchangeControlNumberUpperBound(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interchangeControlNumberUpperBound = mapped
    }

    /**
     * @param value The value indicating whether the message is a test interchange.
     */
    @JvmName("xtdvwpgrwjnqdxvp")
    public suspend fun isTestInterchange(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isTestInterchange = mapped
    }

    /**
     * @param value The value indicating whether to overwrite existing transaction set control number.
     */
    @JvmName("fwqufxmofxmfjbke")
    public suspend fun overwriteExistingTransactionSetControlNumber(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.overwriteExistingTransactionSetControlNumber = mapped
    }

    /**
     * @param value The processing priority code.
     */
    @JvmName("fswyxpkmfpgjfggo")
    public suspend fun processingPriorityCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.processingPriorityCode = mapped
    }

    /**
     * @param value The receiver internal identification.
     */
    @JvmName("kahngskarrxdogay")
    public suspend fun receiverInternalIdentification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.receiverInternalIdentification = mapped
    }

    /**
     * @param value The receiver internal sub identification.
     */
    @JvmName("wjnnoomgvbpppjen")
    public suspend fun receiverInternalSubIdentification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.receiverInternalSubIdentification = mapped
    }

    /**
     * @param value The receiver reverse routing address.
     */
    @JvmName("innumbklvrxqbaak")
    public suspend fun receiverReverseRoutingAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.receiverReverseRoutingAddress = mapped
    }

    /**
     * @param value The recipient reference password qualifier.
     */
    @JvmName("ckowbsxkwdynkkaj")
    public suspend fun recipientReferencePasswordQualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recipientReferencePasswordQualifier = mapped
    }

    /**
     * @param value The recipient reference password value.
     */
    @JvmName("tivjucbjubphhsqs")
    public suspend fun recipientReferencePasswordValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recipientReferencePasswordValue = mapped
    }

    /**
     * @param value The value indicating whether to rollover group control number.
     */
    @JvmName("qqpqloiffatgcsjr")
    public suspend fun rolloverGroupControlNumber(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rolloverGroupControlNumber = mapped
    }

    /**
     * @param value The value indicating whether to rollover interchange control number.
     */
    @JvmName("cqkgqkmkmobcvmmr")
    public suspend fun rolloverInterchangeControlNumber(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rolloverInterchangeControlNumber = mapped
    }

    /**
     * @param value The value indicating whether to rollover transaction set control number.
     */
    @JvmName("meyegplosglovmwi")
    public suspend fun rolloverTransactionSetControlNumber(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rolloverTransactionSetControlNumber = mapped
    }

    /**
     * @param value The sender internal identification.
     */
    @JvmName("vefapbhwepdeqnwq")
    public suspend fun senderInternalIdentification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.senderInternalIdentification = mapped
    }

    /**
     * @param value The sender internal sub identification.
     */
    @JvmName("hafsyqgvgrnpgrhl")
    public suspend fun senderInternalSubIdentification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.senderInternalSubIdentification = mapped
    }

    /**
     * @param value The sender reverse routing address.
     */
    @JvmName("ahtycxmnyrwxuuww")
    public suspend fun senderReverseRoutingAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.senderReverseRoutingAddress = mapped
    }

    /**
     * @param value The transaction set control number lower bound.
     */
    @JvmName("wnmgtrwckboemxlo")
    public suspend fun transactionSetControlNumberLowerBound(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transactionSetControlNumberLowerBound = mapped
    }

    /**
     * @param value The transaction set control number prefix.
     */
    @JvmName("ilxgxhhvgwgtubsn")
    public suspend fun transactionSetControlNumberPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transactionSetControlNumberPrefix = mapped
    }

    /**
     * @param value The transaction set control number suffix.
     */
    @JvmName("whihbohwvfevboyt")
    public suspend fun transactionSetControlNumberSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transactionSetControlNumberSuffix = mapped
    }

    /**
     * @param value The transaction set control number upper bound.
     */
    @JvmName("muwossydbqhhndeb")
    public suspend fun transactionSetControlNumberUpperBound(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transactionSetControlNumberUpperBound = mapped
    }

    internal fun build(): EdifactEnvelopeSettingsArgs = EdifactEnvelopeSettingsArgs(
        applicationReferenceId = applicationReferenceId,
        applyDelimiterStringAdvice = applyDelimiterStringAdvice ?: throw
            PulumiNullFieldException("applyDelimiterStringAdvice"),
        communicationAgreementId = communicationAgreementId,
        createGroupingSegments = createGroupingSegments ?: throw
            PulumiNullFieldException("createGroupingSegments"),
        enableDefaultGroupHeaders = enableDefaultGroupHeaders ?: throw
            PulumiNullFieldException("enableDefaultGroupHeaders"),
        functionalGroupId = functionalGroupId,
        groupApplicationPassword = groupApplicationPassword,
        groupApplicationReceiverId = groupApplicationReceiverId,
        groupApplicationReceiverQualifier = groupApplicationReceiverQualifier,
        groupApplicationSenderId = groupApplicationSenderId,
        groupApplicationSenderQualifier = groupApplicationSenderQualifier,
        groupAssociationAssignedCode = groupAssociationAssignedCode,
        groupControlNumberLowerBound = groupControlNumberLowerBound ?: throw
            PulumiNullFieldException("groupControlNumberLowerBound"),
        groupControlNumberPrefix = groupControlNumberPrefix,
        groupControlNumberSuffix = groupControlNumberSuffix,
        groupControlNumberUpperBound = groupControlNumberUpperBound ?: throw
            PulumiNullFieldException("groupControlNumberUpperBound"),
        groupControllingAgencyCode = groupControllingAgencyCode,
        groupMessageRelease = groupMessageRelease,
        groupMessageVersion = groupMessageVersion,
        interchangeControlNumberLowerBound = interchangeControlNumberLowerBound ?: throw
            PulumiNullFieldException("interchangeControlNumberLowerBound"),
        interchangeControlNumberPrefix = interchangeControlNumberPrefix,
        interchangeControlNumberSuffix = interchangeControlNumberSuffix,
        interchangeControlNumberUpperBound = interchangeControlNumberUpperBound ?: throw
            PulumiNullFieldException("interchangeControlNumberUpperBound"),
        isTestInterchange = isTestInterchange ?: throw PulumiNullFieldException("isTestInterchange"),
        overwriteExistingTransactionSetControlNumber = overwriteExistingTransactionSetControlNumber ?: throw
            PulumiNullFieldException("overwriteExistingTransactionSetControlNumber"),
        processingPriorityCode = processingPriorityCode,
        receiverInternalIdentification = receiverInternalIdentification,
        receiverInternalSubIdentification = receiverInternalSubIdentification,
        receiverReverseRoutingAddress = receiverReverseRoutingAddress,
        recipientReferencePasswordQualifier = recipientReferencePasswordQualifier,
        recipientReferencePasswordValue = recipientReferencePasswordValue,
        rolloverGroupControlNumber = rolloverGroupControlNumber ?: throw
            PulumiNullFieldException("rolloverGroupControlNumber"),
        rolloverInterchangeControlNumber = rolloverInterchangeControlNumber ?: throw
            PulumiNullFieldException("rolloverInterchangeControlNumber"),
        rolloverTransactionSetControlNumber = rolloverTransactionSetControlNumber ?: throw
            PulumiNullFieldException("rolloverTransactionSetControlNumber"),
        senderInternalIdentification = senderInternalIdentification,
        senderInternalSubIdentification = senderInternalSubIdentification,
        senderReverseRoutingAddress = senderReverseRoutingAddress,
        transactionSetControlNumberLowerBound = transactionSetControlNumberLowerBound ?: throw
            PulumiNullFieldException("transactionSetControlNumberLowerBound"),
        transactionSetControlNumberPrefix = transactionSetControlNumberPrefix,
        transactionSetControlNumberSuffix = transactionSetControlNumberSuffix,
        transactionSetControlNumberUpperBound = transactionSetControlNumberUpperBound ?: throw
            PulumiNullFieldException("transactionSetControlNumberUpperBound"),
    )
}
