@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.EdifactSchemaReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Edifact schema reference.
 * @property associationAssignedCode The association assigned code.
 * @property messageId The message id.
 * @property messageRelease The message release version.
 * @property messageVersion The message version.
 * @property schemaName The schema name.
 * @property senderApplicationId The sender application id.
 * @property senderApplicationQualifier The sender application qualifier.
 */
public data class EdifactSchemaReferenceArgs(
    public val associationAssignedCode: Output<String>? = null,
    public val messageId: Output<String>,
    public val messageRelease: Output<String>,
    public val messageVersion: Output<String>,
    public val schemaName: Output<String>,
    public val senderApplicationId: Output<String>? = null,
    public val senderApplicationQualifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.EdifactSchemaReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.EdifactSchemaReferenceArgs =
        com.pulumi.azurenative.logic.inputs.EdifactSchemaReferenceArgs.builder()
            .associationAssignedCode(associationAssignedCode?.applyValue({ args0 -> args0 }))
            .messageId(messageId.applyValue({ args0 -> args0 }))
            .messageRelease(messageRelease.applyValue({ args0 -> args0 }))
            .messageVersion(messageVersion.applyValue({ args0 -> args0 }))
            .schemaName(schemaName.applyValue({ args0 -> args0 }))
            .senderApplicationId(senderApplicationId?.applyValue({ args0 -> args0 }))
            .senderApplicationQualifier(senderApplicationQualifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EdifactSchemaReferenceArgs].
 */
@PulumiTagMarker
public class EdifactSchemaReferenceArgsBuilder internal constructor() {
    private var associationAssignedCode: Output<String>? = null

    private var messageId: Output<String>? = null

    private var messageRelease: Output<String>? = null

    private var messageVersion: Output<String>? = null

    private var schemaName: Output<String>? = null

    private var senderApplicationId: Output<String>? = null

    private var senderApplicationQualifier: Output<String>? = null

    /**
     * @param value The association assigned code.
     */
    @JvmName("cgpoyhurlaqnxrni")
    public suspend fun associationAssignedCode(`value`: Output<String>) {
        this.associationAssignedCode = value
    }

    /**
     * @param value The message id.
     */
    @JvmName("vjvloaqtgjksmbcd")
    public suspend fun messageId(`value`: Output<String>) {
        this.messageId = value
    }

    /**
     * @param value The message release version.
     */
    @JvmName("uuqlovasgigcppat")
    public suspend fun messageRelease(`value`: Output<String>) {
        this.messageRelease = value
    }

    /**
     * @param value The message version.
     */
    @JvmName("higkjmmyhwaashtx")
    public suspend fun messageVersion(`value`: Output<String>) {
        this.messageVersion = value
    }

    /**
     * @param value The schema name.
     */
    @JvmName("jsiqfayplnbmxaic")
    public suspend fun schemaName(`value`: Output<String>) {
        this.schemaName = value
    }

    /**
     * @param value The sender application id.
     */
    @JvmName("jgrmuswrmlimajll")
    public suspend fun senderApplicationId(`value`: Output<String>) {
        this.senderApplicationId = value
    }

    /**
     * @param value The sender application qualifier.
     */
    @JvmName("jkhilqasbwmxesay")
    public suspend fun senderApplicationQualifier(`value`: Output<String>) {
        this.senderApplicationQualifier = value
    }

    /**
     * @param value The association assigned code.
     */
    @JvmName("isaayecmguxucvea")
    public suspend fun associationAssignedCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associationAssignedCode = mapped
    }

    /**
     * @param value The message id.
     */
    @JvmName("ubskkogdyjciqqlp")
    public suspend fun messageId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageId = mapped
    }

    /**
     * @param value The message release version.
     */
    @JvmName("dylatvqdnybfrfjy")
    public suspend fun messageRelease(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageRelease = mapped
    }

    /**
     * @param value The message version.
     */
    @JvmName("cjfnhrwbptrwhoxa")
    public suspend fun messageVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageVersion = mapped
    }

    /**
     * @param value The schema name.
     */
    @JvmName("qclxfyhvyhygqnmm")
    public suspend fun schemaName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaName = mapped
    }

    /**
     * @param value The sender application id.
     */
    @JvmName("ymeqwrjglqetooeh")
    public suspend fun senderApplicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.senderApplicationId = mapped
    }

    /**
     * @param value The sender application qualifier.
     */
    @JvmName("hkygkeudecgkohrh")
    public suspend fun senderApplicationQualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.senderApplicationQualifier = mapped
    }

    internal fun build(): EdifactSchemaReferenceArgs = EdifactSchemaReferenceArgs(
        associationAssignedCode = associationAssignedCode,
        messageId = messageId ?: throw PulumiNullFieldException("messageId"),
        messageRelease = messageRelease ?: throw PulumiNullFieldException("messageRelease"),
        messageVersion = messageVersion ?: throw PulumiNullFieldException("messageVersion"),
        schemaName = schemaName ?: throw PulumiNullFieldException("schemaName"),
        senderApplicationId = senderApplicationId,
        senderApplicationQualifier = senderApplicationQualifier,
    )
}
