@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.EdifactValidationOverrideArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.TrailingSeparatorPolicy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Edifact validation override settings.
 * @property allowLeadingAndTrailingSpacesAndZeroes The value indicating whether to allow leading and trailing spaces and zeroes.
 * @property enforceCharacterSet The value indicating whether to validate character Set.
 * @property messageId The message id on which the validation settings has to be applied.
 * @property trailingSeparatorPolicy The trailing separator policy.
 * @property trimLeadingAndTrailingSpacesAndZeroes The value indicating whether to trim leading and trailing spaces and zeroes.
 * @property validateEDITypes The value indicating whether to validate EDI types.
 * @property validateXSDTypes The value indicating whether to validate XSD types.
 */
public data class EdifactValidationOverrideArgs(
    public val allowLeadingAndTrailingSpacesAndZeroes: Output<Boolean>,
    public val enforceCharacterSet: Output<Boolean>,
    public val messageId: Output<String>,
    public val trailingSeparatorPolicy: Output<Either<String, TrailingSeparatorPolicy>>,
    public val trimLeadingAndTrailingSpacesAndZeroes: Output<Boolean>,
    public val validateEDITypes: Output<Boolean>,
    public val validateXSDTypes: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.EdifactValidationOverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.EdifactValidationOverrideArgs =
        com.pulumi.azurenative.logic.inputs.EdifactValidationOverrideArgs.builder()
            .allowLeadingAndTrailingSpacesAndZeroes(
                allowLeadingAndTrailingSpacesAndZeroes.applyValue({ args0 ->
                    args0
                }),
            )
            .enforceCharacterSet(enforceCharacterSet.applyValue({ args0 -> args0 }))
            .messageId(messageId.applyValue({ args0 -> args0 }))
            .trailingSeparatorPolicy(
                trailingSeparatorPolicy.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .trimLeadingAndTrailingSpacesAndZeroes(
                trimLeadingAndTrailingSpacesAndZeroes.applyValue({ args0 ->
                    args0
                }),
            )
            .validateEDITypes(validateEDITypes.applyValue({ args0 -> args0 }))
            .validateXSDTypes(validateXSDTypes.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EdifactValidationOverrideArgs].
 */
@PulumiTagMarker
public class EdifactValidationOverrideArgsBuilder internal constructor() {
    private var allowLeadingAndTrailingSpacesAndZeroes: Output<Boolean>? = null

    private var enforceCharacterSet: Output<Boolean>? = null

    private var messageId: Output<String>? = null

    private var trailingSeparatorPolicy: Output<Either<String, TrailingSeparatorPolicy>>? = null

    private var trimLeadingAndTrailingSpacesAndZeroes: Output<Boolean>? = null

    private var validateEDITypes: Output<Boolean>? = null

    private var validateXSDTypes: Output<Boolean>? = null

    /**
     * @param value The value indicating whether to allow leading and trailing spaces and zeroes.
     */
    @JvmName("cmsaropdwwatdyew")
    public suspend fun allowLeadingAndTrailingSpacesAndZeroes(`value`: Output<Boolean>) {
        this.allowLeadingAndTrailingSpacesAndZeroes = value
    }

    /**
     * @param value The value indicating whether to validate character Set.
     */
    @JvmName("fdgxlognaisnhdxp")
    public suspend fun enforceCharacterSet(`value`: Output<Boolean>) {
        this.enforceCharacterSet = value
    }

    /**
     * @param value The message id on which the validation settings has to be applied.
     */
    @JvmName("xjntyjgdujfxquwi")
    public suspend fun messageId(`value`: Output<String>) {
        this.messageId = value
    }

    /**
     * @param value The trailing separator policy.
     */
    @JvmName("yovnacotilamaiug")
    public suspend
    fun trailingSeparatorPolicy(`value`: Output<Either<String, TrailingSeparatorPolicy>>) {
        this.trailingSeparatorPolicy = value
    }

    /**
     * @param value The value indicating whether to trim leading and trailing spaces and zeroes.
     */
    @JvmName("alhwtxwlwopnusgu")
    public suspend fun trimLeadingAndTrailingSpacesAndZeroes(`value`: Output<Boolean>) {
        this.trimLeadingAndTrailingSpacesAndZeroes = value
    }

    /**
     * @param value The value indicating whether to validate EDI types.
     */
    @JvmName("pkspicbgaxxupvud")
    public suspend fun validateEDITypes(`value`: Output<Boolean>) {
        this.validateEDITypes = value
    }

    /**
     * @param value The value indicating whether to validate XSD types.
     */
    @JvmName("moqrwbnvwdrawqei")
    public suspend fun validateXSDTypes(`value`: Output<Boolean>) {
        this.validateXSDTypes = value
    }

    /**
     * @param value The value indicating whether to allow leading and trailing spaces and zeroes.
     */
    @JvmName("xghveyudliygdbwj")
    public suspend fun allowLeadingAndTrailingSpacesAndZeroes(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowLeadingAndTrailingSpacesAndZeroes = mapped
    }

    /**
     * @param value The value indicating whether to validate character Set.
     */
    @JvmName("lryjkvmahgbvolvp")
    public suspend fun enforceCharacterSet(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enforceCharacterSet = mapped
    }

    /**
     * @param value The message id on which the validation settings has to be applied.
     */
    @JvmName("lusdyofxhfpnxvdp")
    public suspend fun messageId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageId = mapped
    }

    /**
     * @param value The trailing separator policy.
     */
    @JvmName("dpnnovunciwnpqnn")
    public suspend fun trailingSeparatorPolicy(`value`: Either<String, TrailingSeparatorPolicy>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trailingSeparatorPolicy = mapped
    }

    /**
     * @param value The trailing separator policy.
     */
    @JvmName("gnvwvwmdrbmoqpaf")
    public fun trailingSeparatorPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TrailingSeparatorPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trailingSeparatorPolicy = mapped
    }

    /**
     * @param value The trailing separator policy.
     */
    @JvmName("xjkkqgmdxsqnxkea")
    public fun trailingSeparatorPolicy(`value`: TrailingSeparatorPolicy) {
        val toBeMapped = Either.ofRight<String, TrailingSeparatorPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trailingSeparatorPolicy = mapped
    }

    /**
     * @param value The value indicating whether to trim leading and trailing spaces and zeroes.
     */
    @JvmName("odrwxqqbjfjhxqcs")
    public suspend fun trimLeadingAndTrailingSpacesAndZeroes(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trimLeadingAndTrailingSpacesAndZeroes = mapped
    }

    /**
     * @param value The value indicating whether to validate EDI types.
     */
    @JvmName("pffcohauymemgnfp")
    public suspend fun validateEDITypes(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validateEDITypes = mapped
    }

    /**
     * @param value The value indicating whether to validate XSD types.
     */
    @JvmName("nxvjlvjubuwtqrrb")
    public suspend fun validateXSDTypes(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validateXSDTypes = mapped
    }

    internal fun build(): EdifactValidationOverrideArgs = EdifactValidationOverrideArgs(
        allowLeadingAndTrailingSpacesAndZeroes = allowLeadingAndTrailingSpacesAndZeroes ?: throw
            PulumiNullFieldException("allowLeadingAndTrailingSpacesAndZeroes"),
        enforceCharacterSet = enforceCharacterSet ?: throw PulumiNullFieldException("enforceCharacterSet"),
        messageId = messageId ?: throw PulumiNullFieldException("messageId"),
        trailingSeparatorPolicy = trailingSeparatorPolicy ?: throw
            PulumiNullFieldException("trailingSeparatorPolicy"),
        trimLeadingAndTrailingSpacesAndZeroes = trimLeadingAndTrailingSpacesAndZeroes ?: throw
            PulumiNullFieldException("trimLeadingAndTrailingSpacesAndZeroes"),
        validateEDITypes = validateEDITypes ?: throw PulumiNullFieldException("validateEDITypes"),
        validateXSDTypes = validateXSDTypes ?: throw PulumiNullFieldException("validateXSDTypes"),
    )
}
