@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.GetIntegrationAccountAssemblyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property assemblyArtifactName The assembly artifact name.
 * @property integrationAccountName The integration account name.
 * @property resourceGroupName The resource group name.
 */
public data class GetIntegrationAccountAssemblyPlainArgs(
    public val assemblyArtifactName: String,
    public val integrationAccountName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.GetIntegrationAccountAssemblyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.GetIntegrationAccountAssemblyPlainArgs =
        com.pulumi.azurenative.logic.inputs.GetIntegrationAccountAssemblyPlainArgs.builder()
            .assemblyArtifactName(assemblyArtifactName.let({ args0 -> args0 }))
            .integrationAccountName(integrationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationAccountAssemblyPlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationAccountAssemblyPlainArgsBuilder internal constructor() {
    private var assemblyArtifactName: String? = null

    private var integrationAccountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The assembly artifact name.
     */
    @JvmName("dpwycgwechstmvmr")
    public suspend fun assemblyArtifactName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assemblyArtifactName = mapped
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("kcagyejsagilxpqr")
    public suspend fun integrationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("fllxqlebxnygqtri")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIntegrationAccountAssemblyPlainArgs =
        GetIntegrationAccountAssemblyPlainArgs(
            assemblyArtifactName = assemblyArtifactName ?: throw
                PulumiNullFieldException("assemblyArtifactName"),
            integrationAccountName = integrationAccountName ?: throw
                PulumiNullFieldException("integrationAccountName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
