@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.GetIntegrationAccountBatchConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property batchConfigurationName The batch configuration name.
 * @property integrationAccountName The integration account name.
 * @property resourceGroupName The resource group name.
 */
public data class GetIntegrationAccountBatchConfigurationPlainArgs(
    public val batchConfigurationName: String,
    public val integrationAccountName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.GetIntegrationAccountBatchConfigurationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.GetIntegrationAccountBatchConfigurationPlainArgs =
        com.pulumi.azurenative.logic.inputs.GetIntegrationAccountBatchConfigurationPlainArgs.builder()
            .batchConfigurationName(batchConfigurationName.let({ args0 -> args0 }))
            .integrationAccountName(integrationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationAccountBatchConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationAccountBatchConfigurationPlainArgsBuilder internal constructor() {
    private var batchConfigurationName: String? = null

    private var integrationAccountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The batch configuration name.
     */
    @JvmName("mqestrwkrkxjhcpn")
    public suspend fun batchConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.batchConfigurationName = mapped
    }

    /**
     * @param value The integration account name.
     */
    @JvmName("cragnhnbkxxstgpm")
    public suspend fun integrationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("aqmlkkthyjjogtpq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIntegrationAccountBatchConfigurationPlainArgs =
        GetIntegrationAccountBatchConfigurationPlainArgs(
            batchConfigurationName = batchConfigurationName ?: throw
                PulumiNullFieldException("batchConfigurationName"),
            integrationAccountName = integrationAccountName ?: throw
                PulumiNullFieldException("integrationAccountName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
