@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.GetIntegrationAccountSchemaPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property integrationAccountName The integration account name.
 * @property resourceGroupName The resource group name.
 * @property schemaName The integration account schema name.
 */
public data class GetIntegrationAccountSchemaPlainArgs(
    public val integrationAccountName: String,
    public val resourceGroupName: String,
    public val schemaName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.GetIntegrationAccountSchemaPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.GetIntegrationAccountSchemaPlainArgs =
        com.pulumi.azurenative.logic.inputs.GetIntegrationAccountSchemaPlainArgs.builder()
            .integrationAccountName(integrationAccountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .schemaName(schemaName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationAccountSchemaPlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationAccountSchemaPlainArgsBuilder internal constructor() {
    private var integrationAccountName: String? = null

    private var resourceGroupName: String? = null

    private var schemaName: String? = null

    /**
     * @param value The integration account name.
     */
    @JvmName("xirimdshdvjwesjk")
    public suspend fun integrationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("sudnxxtfpupsqgsm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The integration account schema name.
     */
    @JvmName("rpspkaoiiwyqrrdf")
    public suspend fun schemaName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.schemaName = mapped
    }

    internal fun build(): GetIntegrationAccountSchemaPlainArgs = GetIntegrationAccountSchemaPlainArgs(
        integrationAccountName = integrationAccountName ?: throw
            PulumiNullFieldException("integrationAccountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        schemaName = schemaName ?: throw PulumiNullFieldException("schemaName"),
    )
}
