@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.GetWorkflowAccessKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessKeyName The workflow access key name.
 * @property resourceGroupName The resource group name.
 * @property workflowName The workflow name.
 */
public data class GetWorkflowAccessKeyPlainArgs(
    public val accessKeyName: String,
    public val resourceGroupName: String,
    public val workflowName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.GetWorkflowAccessKeyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.GetWorkflowAccessKeyPlainArgs =
        com.pulumi.azurenative.logic.inputs.GetWorkflowAccessKeyPlainArgs.builder()
            .accessKeyName(accessKeyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workflowName(workflowName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkflowAccessKeyPlainArgs].
 */
@PulumiTagMarker
public class GetWorkflowAccessKeyPlainArgsBuilder internal constructor() {
    private var accessKeyName: String? = null

    private var resourceGroupName: String? = null

    private var workflowName: String? = null

    /**
     * @param value The workflow access key name.
     */
    @JvmName("bkrepqvccmmmcahj")
    public suspend fun accessKeyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accessKeyName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("lnirwqyatnvawuha")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The workflow name.
     */
    @JvmName("usbyveaarkeejrev")
    public suspend fun workflowName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workflowName = mapped
    }

    internal fun build(): GetWorkflowAccessKeyPlainArgs = GetWorkflowAccessKeyPlainArgs(
        accessKeyName = accessKeyName ?: throw PulumiNullFieldException("accessKeyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workflowName = workflowName ?: throw PulumiNullFieldException("workflowName"),
    )
}
