@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmenEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The encryption configuration for the integration service environment.
 * @property encryptionKeyReference The encryption key reference.
 */
public data class IntegrationServiceEnvironmenEncryptionConfigurationArgs(
    public val encryptionKeyReference: Output<IntegrationServiceEnvironmenEncryptionKeyReferenceArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmenEncryptionConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmenEncryptionConfigurationArgs =
        com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmenEncryptionConfigurationArgs.builder()
            .encryptionKeyReference(
                encryptionKeyReference?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [IntegrationServiceEnvironmenEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class IntegrationServiceEnvironmenEncryptionConfigurationArgsBuilder internal constructor() {
    private var encryptionKeyReference:
        Output<IntegrationServiceEnvironmenEncryptionKeyReferenceArgs>? = null

    /**
     * @param value The encryption key reference.
     */
    @JvmName("mwhftcudpmykagbo")
    public suspend
    fun encryptionKeyReference(`value`: Output<IntegrationServiceEnvironmenEncryptionKeyReferenceArgs>) {
        this.encryptionKeyReference = value
    }

    /**
     * @param value The encryption key reference.
     */
    @JvmName("cunwsbrpdkyfnpid")
    public suspend
    fun encryptionKeyReference(`value`: IntegrationServiceEnvironmenEncryptionKeyReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKeyReference = mapped
    }

    /**
     * @param argument The encryption key reference.
     */
    @JvmName("duveloyhkapvovhm")
    public suspend
    fun encryptionKeyReference(argument: suspend IntegrationServiceEnvironmenEncryptionKeyReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationServiceEnvironmenEncryptionKeyReferenceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.encryptionKeyReference = mapped
    }

    internal fun build(): IntegrationServiceEnvironmenEncryptionConfigurationArgs =
        IntegrationServiceEnvironmenEncryptionConfigurationArgs(
            encryptionKeyReference = encryptionKeyReference,
        )
}
