@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentAccessEndpointArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.IntegrationServiceEnvironmentAccessEndpointType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The integration service environment access endpoint.
 * @property type The access endpoint type.
 */
public data class IntegrationServiceEnvironmentAccessEndpointArgs(
    public val type: Output<Either<String, IntegrationServiceEnvironmentAccessEndpointType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentAccessEndpointArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentAccessEndpointArgs =
        com.pulumi.azurenative.logic.inputs.IntegrationServiceEnvironmentAccessEndpointArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IntegrationServiceEnvironmentAccessEndpointArgs].
 */
@PulumiTagMarker
public class IntegrationServiceEnvironmentAccessEndpointArgsBuilder internal constructor() {
    private var type: Output<Either<String, IntegrationServiceEnvironmentAccessEndpointType>>? = null

    /**
     * @param value The access endpoint type.
     */
    @JvmName("jdvcvenfiajoyygj")
    public suspend
    fun type(`value`: Output<Either<String, IntegrationServiceEnvironmentAccessEndpointType>>) {
        this.type = value
    }

    /**
     * @param value The access endpoint type.
     */
    @JvmName("emqejqgxbjqtwuko")
    public suspend
    fun type(`value`: Either<String, IntegrationServiceEnvironmentAccessEndpointType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The access endpoint type.
     */
    @JvmName("boojdqqdbbmafelv")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IntegrationServiceEnvironmentAccessEndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The access endpoint type.
     */
    @JvmName("cnhjvnxxmofpmxku")
    public fun type(`value`: IntegrationServiceEnvironmentAccessEndpointType) {
        val toBeMapped = Either.ofRight<String, IntegrationServiceEnvironmentAccessEndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IntegrationServiceEnvironmentAccessEndpointArgs =
        IntegrationServiceEnvironmentAccessEndpointArgs(
            type = type,
        )
}
