@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.IpAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The ip address.
 * @property address The address.
 */
public data class IpAddressArgs(
    public val address: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.IpAddressArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.IpAddressArgs =
        com.pulumi.azurenative.logic.inputs.IpAddressArgs.builder()
            .address(address?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpAddressArgs].
 */
@PulumiTagMarker
public class IpAddressArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    /**
     * @param value The address.
     */
    @JvmName("binactbwgejsplbc")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The address.
     */
    @JvmName("lmcogbpkufeubxin")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    internal fun build(): IpAddressArgs = IpAddressArgs(
        address = address,
    )
}
