@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.ListIntegrationAccountKeyVaultKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property integrationAccountName The integration account name.
 * @property keyVault The key vault reference.
 * @property resourceGroupName The resource group name.
 * @property skipToken The skip token.
 */
public data class ListIntegrationAccountKeyVaultKeysPlainArgs(
    public val integrationAccountName: String,
    public val keyVault: KeyVaultReference,
    public val resourceGroupName: String,
    public val skipToken: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.logic.inputs.ListIntegrationAccountKeyVaultKeysPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.logic.inputs.ListIntegrationAccountKeyVaultKeysPlainArgs =
        com.pulumi.azurenative.logic.inputs.ListIntegrationAccountKeyVaultKeysPlainArgs.builder()
            .integrationAccountName(integrationAccountName.let({ args0 -> args0 }))
            .keyVault(keyVault.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skipToken(skipToken?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListIntegrationAccountKeyVaultKeysPlainArgs].
 */
@PulumiTagMarker
public class ListIntegrationAccountKeyVaultKeysPlainArgsBuilder internal constructor() {
    private var integrationAccountName: String? = null

    private var keyVault: KeyVaultReference? = null

    private var resourceGroupName: String? = null

    private var skipToken: String? = null

    /**
     * @param value The integration account name.
     */
    @JvmName("sddfsfcicktyhxcv")
    public suspend fun integrationAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationAccountName = mapped
    }

    /**
     * @param value The key vault reference.
     */
    @JvmName("vvgcwmrsrsakpolq")
    public suspend fun keyVault(`value`: KeyVaultReference) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyVault = mapped
    }

    /**
     * @param argument The key vault reference.
     */
    @JvmName("kwmfhgmelwnnlqgi")
    public suspend fun keyVault(argument: suspend KeyVaultReferenceBuilder.() -> Unit) {
        val toBeMapped = KeyVaultReferenceBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.keyVault = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("krmwwvkjloitjigt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The skip token.
     */
    @JvmName("oqvhgwpfwvqgklii")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    internal fun build(): ListIntegrationAccountKeyVaultKeysPlainArgs =
        ListIntegrationAccountKeyVaultKeysPlainArgs(
            integrationAccountName = integrationAccountName ?: throw
                PulumiNullFieldException("integrationAccountName"),
            keyVault = keyVault ?: throw PulumiNullFieldException("keyVault"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            skipToken = skipToken,
        )
}
