@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.ListWorkflowTriggerCallbackUrlPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The resource group name.
 * @property triggerName The workflow trigger name.
 * @property workflowName The workflow name.
 */
public data class ListWorkflowTriggerCallbackUrlPlainArgs(
    public val resourceGroupName: String,
    public val triggerName: String,
    public val workflowName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.ListWorkflowTriggerCallbackUrlPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.ListWorkflowTriggerCallbackUrlPlainArgs =
        com.pulumi.azurenative.logic.inputs.ListWorkflowTriggerCallbackUrlPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .triggerName(triggerName.let({ args0 -> args0 }))
            .workflowName(workflowName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWorkflowTriggerCallbackUrlPlainArgs].
 */
@PulumiTagMarker
public class ListWorkflowTriggerCallbackUrlPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var triggerName: String? = null

    private var workflowName: String? = null

    /**
     * @param value The resource group name.
     */
    @JvmName("bdcdbeyjjishfqpy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The workflow trigger name.
     */
    @JvmName("ywbgogwqbbflekhq")
    public suspend fun triggerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.triggerName = mapped
    }

    /**
     * @param value The workflow name.
     */
    @JvmName("lnolbydiwmqtsrrd")
    public suspend fun workflowName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workflowName = mapped
    }

    internal fun build(): ListWorkflowTriggerCallbackUrlPlainArgs =
        ListWorkflowTriggerCallbackUrlPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            triggerName = triggerName ?: throw PulumiNullFieldException("triggerName"),
            workflowName = workflowName ?: throw PulumiNullFieldException("workflowName"),
        )
}
