@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.ListWorkflowVersionCallbackUrlPlainArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.KeyType
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyType The key type.
 * @property notAfter The expiry time.
 * @property resourceGroupName The resource group name.
 * @property triggerName The workflow trigger name.
 * @property versionId The workflow versionId.
 * @property workflowName The workflow name.
 */
public data class ListWorkflowVersionCallbackUrlPlainArgs(
    public val keyType: KeyType? = null,
    public val notAfter: String? = null,
    public val resourceGroupName: String,
    public val triggerName: String,
    public val versionId: String,
    public val workflowName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.ListWorkflowVersionCallbackUrlPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.ListWorkflowVersionCallbackUrlPlainArgs =
        com.pulumi.azurenative.logic.inputs.ListWorkflowVersionCallbackUrlPlainArgs.builder()
            .keyType(keyType?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .notAfter(notAfter?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .triggerName(triggerName.let({ args0 -> args0 }))
            .versionId(versionId.let({ args0 -> args0 }))
            .workflowName(workflowName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWorkflowVersionCallbackUrlPlainArgs].
 */
@PulumiTagMarker
public class ListWorkflowVersionCallbackUrlPlainArgsBuilder internal constructor() {
    private var keyType: KeyType? = null

    private var notAfter: String? = null

    private var resourceGroupName: String? = null

    private var triggerName: String? = null

    private var versionId: String? = null

    private var workflowName: String? = null

    /**
     * @param value The key type.
     */
    @JvmName("solyligemcrvgvbe")
    public suspend fun keyType(`value`: KeyType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyType = mapped
    }

    /**
     * @param value The expiry time.
     */
    @JvmName("ydgdmbjxtyrhklmt")
    public suspend fun notAfter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.notAfter = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("xmuumfufiffpiuah")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The workflow trigger name.
     */
    @JvmName("frlndkpcfjartxex")
    public suspend fun triggerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.triggerName = mapped
    }

    /**
     * @param value The workflow versionId.
     */
    @JvmName("fcdwguecatqdoxyg")
    public suspend fun versionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.versionId = mapped
    }

    /**
     * @param value The workflow name.
     */
    @JvmName("dkisdxlralnwxksx")
    public suspend fun workflowName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workflowName = mapped
    }

    internal fun build(): ListWorkflowVersionCallbackUrlPlainArgs =
        ListWorkflowVersionCallbackUrlPlainArgs(
            keyType = keyType,
            notAfter = notAfter,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            triggerName = triggerName ?: throw PulumiNullFieldException("triggerName"),
            versionId = versionId ?: throw PulumiNullFieldException("versionId"),
            workflowName = workflowName ?: throw PulumiNullFieldException("workflowName"),
        )
}
