@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.NetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The network configuration.
 * @property accessEndpoint The access endpoint.
 * @property subnets The subnets.
 * @property virtualNetworkAddressSpace Gets the virtual network address space.
 */
public data class NetworkConfigurationArgs(
    public val accessEndpoint: Output<IntegrationServiceEnvironmentAccessEndpointArgs>? = null,
    public val subnets: Output<List<ResourceReferenceArgs>>? = null,
    public val virtualNetworkAddressSpace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.NetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.NetworkConfigurationArgs =
        com.pulumi.azurenative.logic.inputs.NetworkConfigurationArgs.builder()
            .accessEndpoint(accessEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnets(
                subnets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .virtualNetworkAddressSpace(virtualNetworkAddressSpace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkConfigurationArgs].
 */
@PulumiTagMarker
public class NetworkConfigurationArgsBuilder internal constructor() {
    private var accessEndpoint: Output<IntegrationServiceEnvironmentAccessEndpointArgs>? = null

    private var subnets: Output<List<ResourceReferenceArgs>>? = null

    private var virtualNetworkAddressSpace: Output<String>? = null

    /**
     * @param value The access endpoint.
     */
    @JvmName("gqxmiwdtvpwkudmq")
    public suspend
    fun accessEndpoint(`value`: Output<IntegrationServiceEnvironmentAccessEndpointArgs>) {
        this.accessEndpoint = value
    }

    /**
     * @param value The subnets.
     */
    @JvmName("sleqdcbdempktcqu")
    public suspend fun subnets(`value`: Output<List<ResourceReferenceArgs>>) {
        this.subnets = value
    }

    @JvmName("mttxsvnqbnpcntik")
    public suspend fun subnets(vararg values: Output<ResourceReferenceArgs>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values The subnets.
     */
    @JvmName("olhkjggnjseuqjkl")
    public suspend fun subnets(values: List<Output<ResourceReferenceArgs>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value Gets the virtual network address space.
     */
    @JvmName("ordalxdkufwjxgsd")
    public suspend fun virtualNetworkAddressSpace(`value`: Output<String>) {
        this.virtualNetworkAddressSpace = value
    }

    /**
     * @param value The access endpoint.
     */
    @JvmName("cjmphhmyfrxayeev")
    public suspend fun accessEndpoint(`value`: IntegrationServiceEnvironmentAccessEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessEndpoint = mapped
    }

    /**
     * @param argument The access endpoint.
     */
    @JvmName("llkytipvmjvnexxf")
    public suspend
    fun accessEndpoint(argument: suspend IntegrationServiceEnvironmentAccessEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationServiceEnvironmentAccessEndpointArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.accessEndpoint = mapped
    }

    /**
     * @param value The subnets.
     */
    @JvmName("uevsfrbpjfohpcao")
    public suspend fun subnets(`value`: List<ResourceReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param argument The subnets.
     */
    @JvmName("hnsoddoykhricrbm")
    public suspend fun subnets(argument: List<suspend ResourceReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument The subnets.
     */
    @JvmName("dbxcrwhmuswqmywa")
    public suspend fun subnets(vararg argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ResourceReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument The subnets.
     */
    @JvmName("nfwwsnhvrfrtafbj")
    public suspend fun subnets(argument: suspend ResourceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param values The subnets.
     */
    @JvmName("ofxilbpkcxlgwead")
    public suspend fun subnets(vararg values: ResourceReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param value Gets the virtual network address space.
     */
    @JvmName("tjqykwbjgeligfsx")
    public suspend fun virtualNetworkAddressSpace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkAddressSpace = mapped
    }

    internal fun build(): NetworkConfigurationArgs = NetworkConfigurationArgs(
        accessEndpoint = accessEndpoint,
        subnets = subnets,
        virtualNetworkAddressSpace = virtualNetworkAddressSpace,
    )
}
