@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.inputs

import com.pulumi.azurenative.logic.inputs.X12MessageFilterArgs.builder
import com.pulumi.azurenative.logic.kotlin.enums.MessageFilterType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The X12 message filter for odata query.
 * @property messageFilterType The message filter type.
 */
public data class X12MessageFilterArgs(
    public val messageFilterType: Output<Either<String, MessageFilterType>>,
) : ConvertibleToJava<com.pulumi.azurenative.logic.inputs.X12MessageFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.logic.inputs.X12MessageFilterArgs =
        com.pulumi.azurenative.logic.inputs.X12MessageFilterArgs.builder()
            .messageFilterType(
                messageFilterType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [X12MessageFilterArgs].
 */
@PulumiTagMarker
public class X12MessageFilterArgsBuilder internal constructor() {
    private var messageFilterType: Output<Either<String, MessageFilterType>>? = null

    /**
     * @param value The message filter type.
     */
    @JvmName("ugnttncugmlrehod")
    public suspend fun messageFilterType(`value`: Output<Either<String, MessageFilterType>>) {
        this.messageFilterType = value
    }

    /**
     * @param value The message filter type.
     */
    @JvmName("mbykkoupmtkrnfkf")
    public suspend fun messageFilterType(`value`: Either<String, MessageFilterType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageFilterType = mapped
    }

    /**
     * @param value The message filter type.
     */
    @JvmName("dcbnaxmfaxjskjfw")
    public fun messageFilterType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MessageFilterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageFilterType = mapped
    }

    /**
     * @param value The message filter type.
     */
    @JvmName("pbpfihxiuhjtvymv")
    public fun messageFilterType(`value`: MessageFilterType) {
        val toBeMapped = Either.ofRight<String, MessageFilterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageFilterType = mapped
    }

    internal fun build(): X12MessageFilterArgs = X12MessageFilterArgs(
        messageFilterType = messageFilterType ?: throw PulumiNullFieldException("messageFilterType"),
    )
}
