@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress

/**
 * The integration account agreement content.
 * @property aS2 The AS2 agreement content.
 * @property edifact The EDIFACT agreement content.
 * @property x12 The X12 agreement content.
 */
public data class AgreementContentResponse(
    public val aS2: AS2AgreementContentResponse? = null,
    public val edifact: EdifactAgreementContentResponse? = null,
    public val x12: X12AgreementContentResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.AgreementContentResponse):
            AgreementContentResponse = AgreementContentResponse(
            aS2 = javaType.aS2().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.AS2AgreementContentResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            edifact = javaType.edifact().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.EdifactAgreementContentResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            x12 = javaType.x12().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.X12AgreementContentResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
