@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The integration account partner's business identity.
 * @property qualifier The business identity qualifier e.g. as2identity, ZZ, ZZZ, 31, 32
 * @property value The user defined business identity value.
 */
public data class BusinessIdentityResponse(
    public val qualifier: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.BusinessIdentityResponse):
            BusinessIdentityResponse = BusinessIdentityResponse(
            qualifier = javaType.qualifier(),
            `value` = javaType.`value`(),
        )
    }
}
