@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The flow endpoints configuration.
 * @property accessEndpointIpAddresses The access endpoint ip address.
 * @property outgoingIpAddresses The outgoing ip address.
 */
public data class FlowEndpointsResponse(
    public val accessEndpointIpAddresses: List<IpAddressResponse>? = null,
    public val outgoingIpAddresses: List<IpAddressResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.FlowEndpointsResponse):
            FlowEndpointsResponse = FlowEndpointsResponse(
            accessEndpointIpAddresses = javaType.accessEndpointIpAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.IpAddressResponse.Companion.toKotlin(args0)
                })
            }),
            outgoingIpAddresses = javaType.outgoingIpAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.IpAddressResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
