@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The integration account session.
 * @property changedTime The changed time.
 * @property content The session content.
 * @property createdTime The created time.
 * @property id The resource id.
 * @property location The resource location.
 * @property name Gets the resource name.
 * @property tags The resource tags.
 * @property type Gets the resource type.
 */
public data class GetIntegrationAccountSessionResult(
    public val changedTime: String,
    public val content: Any? = null,
    public val createdTime: String,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.GetIntegrationAccountSessionResult):
            GetIntegrationAccountSessionResult = GetIntegrationAccountSessionResult(
            changedTime = javaType.changedTime(),
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            createdTime = javaType.createdTime(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
