@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id Gets or sets the resource id.
 * @property name Gets the workflow access key name.
 * @property notAfter Gets or sets the not-after time.
 * @property notBefore Gets or sets the not-before time.
 * @property type Gets the workflow access key type.
 */
public data class GetWorkflowAccessKeyResult(
    public val id: String? = null,
    public val name: String,
    public val notAfter: String? = null,
    public val notBefore: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.GetWorkflowAccessKeyResult):
            GetWorkflowAccessKeyResult = GetWorkflowAccessKeyResult(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            notAfter = javaType.notAfter().map({ args0 -> args0 }).orElse(null),
            notBefore = javaType.notBefore().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
