@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The integration service environment sku.
 * @property capacity The sku capacity.
 * @property name The sku name.
 */
public data class IntegrationServiceEnvironmentSkuResponse(
    public val capacity: Int? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.IntegrationServiceEnvironmentSkuResponse):
            IntegrationServiceEnvironmentSkuResponse = IntegrationServiceEnvironmentSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
