@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The network configuration.
 * @property accessEndpoint The access endpoint.
 * @property subnets The subnets.
 * @property virtualNetworkAddressSpace Gets the virtual network address space.
 */
public data class NetworkConfigurationResponse(
    public val accessEndpoint: IntegrationServiceEnvironmentAccessEndpointResponse? = null,
    public val subnets: List<ResourceReferenceResponse>? = null,
    public val virtualNetworkAddressSpace: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.NetworkConfigurationResponse):
            NetworkConfigurationResponse = NetworkConfigurationResponse(
            accessEndpoint = javaType.accessEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.IntegrationServiceEnvironmentAccessEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            virtualNetworkAddressSpace = javaType.virtualNetworkAddressSpace().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
