@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The integration account RosettaNet ProcessConfiguration role settings.
 * @property action The action name.
 * @property businessDocument The RosettaNet ProcessConfiguration business document.
 * @property description The description.
 * @property role The role name.
 * @property roleType The RosettaNet ProcessConfiguration role type.
 * @property service The service name.
 * @property serviceClassification The service classification name.
 */
public data class RosettaNetPipRoleSettingsResponse(
    public val action: String,
    public val businessDocument: RosettaNetPipBusinessDocumentResponse,
    public val description: String? = null,
    public val role: String,
    public val roleType: String,
    public val service: String,
    public val serviceClassification: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.RosettaNetPipRoleSettingsResponse):
            RosettaNetPipRoleSettingsResponse = RosettaNetPipRoleSettingsResponse(
            action = javaType.action(),
            businessDocument = javaType.businessDocument().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.RosettaNetPipBusinessDocumentResponse.Companion.toKotlin(args0)
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            role = javaType.role(),
            roleType = javaType.roleType(),
            service = javaType.service(),
            serviceClassification = javaType.serviceClassification(),
        )
    }
}
