@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin

import com.pulumi.azurenative.logz.LogzFunctions.getMetricsSourcePlain
import com.pulumi.azurenative.logz.LogzFunctions.getMetricsSourceTagRulePlain
import com.pulumi.azurenative.logz.LogzFunctions.getMonitorPlain
import com.pulumi.azurenative.logz.LogzFunctions.getSubAccountPlain
import com.pulumi.azurenative.logz.LogzFunctions.getSubAccountTagRulePlain
import com.pulumi.azurenative.logz.LogzFunctions.getTagRulePlain
import com.pulumi.azurenative.logz.LogzFunctions.listMonitorMonitoredResourcesPlain
import com.pulumi.azurenative.logz.LogzFunctions.listMonitorUserRolesPlain
import com.pulumi.azurenative.logz.LogzFunctions.listMonitorVMHostsPlain
import com.pulumi.azurenative.logz.LogzFunctions.listSubAccountMonitoredResourcesPlain
import com.pulumi.azurenative.logz.LogzFunctions.listSubAccountVMHostsPlain
import com.pulumi.azurenative.logz.kotlin.inputs.GetMetricsSourcePlainArgs
import com.pulumi.azurenative.logz.kotlin.inputs.GetMetricsSourcePlainArgsBuilder
import com.pulumi.azurenative.logz.kotlin.inputs.GetMetricsSourceTagRulePlainArgs
import com.pulumi.azurenative.logz.kotlin.inputs.GetMetricsSourceTagRulePlainArgsBuilder
import com.pulumi.azurenative.logz.kotlin.inputs.GetMonitorPlainArgs
import com.pulumi.azurenative.logz.kotlin.inputs.GetMonitorPlainArgsBuilder
import com.pulumi.azurenative.logz.kotlin.inputs.GetSubAccountPlainArgs
import com.pulumi.azurenative.logz.kotlin.inputs.GetSubAccountPlainArgsBuilder
import com.pulumi.azurenative.logz.kotlin.inputs.GetSubAccountTagRulePlainArgs
import com.pulumi.azurenative.logz.kotlin.inputs.GetSubAccountTagRulePlainArgsBuilder
import com.pulumi.azurenative.logz.kotlin.inputs.GetTagRulePlainArgs
import com.pulumi.azurenative.logz.kotlin.inputs.GetTagRulePlainArgsBuilder
import com.pulumi.azurenative.logz.kotlin.inputs.ListMonitorMonitoredResourcesPlainArgs
import com.pulumi.azurenative.logz.kotlin.inputs.ListMonitorMonitoredResourcesPlainArgsBuilder
import com.pulumi.azurenative.logz.kotlin.inputs.ListMonitorUserRolesPlainArgs
import com.pulumi.azurenative.logz.kotlin.inputs.ListMonitorUserRolesPlainArgsBuilder
import com.pulumi.azurenative.logz.kotlin.inputs.ListMonitorVMHostsPlainArgs
import com.pulumi.azurenative.logz.kotlin.inputs.ListMonitorVMHostsPlainArgsBuilder
import com.pulumi.azurenative.logz.kotlin.inputs.ListSubAccountMonitoredResourcesPlainArgs
import com.pulumi.azurenative.logz.kotlin.inputs.ListSubAccountMonitoredResourcesPlainArgsBuilder
import com.pulumi.azurenative.logz.kotlin.inputs.ListSubAccountVMHostsPlainArgs
import com.pulumi.azurenative.logz.kotlin.inputs.ListSubAccountVMHostsPlainArgsBuilder
import com.pulumi.azurenative.logz.kotlin.outputs.GetMetricsSourceResult
import com.pulumi.azurenative.logz.kotlin.outputs.GetMetricsSourceTagRuleResult
import com.pulumi.azurenative.logz.kotlin.outputs.GetMonitorResult
import com.pulumi.azurenative.logz.kotlin.outputs.GetSubAccountResult
import com.pulumi.azurenative.logz.kotlin.outputs.GetSubAccountTagRuleResult
import com.pulumi.azurenative.logz.kotlin.outputs.GetTagRuleResult
import com.pulumi.azurenative.logz.kotlin.outputs.ListMonitorMonitoredResourcesResult
import com.pulumi.azurenative.logz.kotlin.outputs.ListMonitorUserRolesResult
import com.pulumi.azurenative.logz.kotlin.outputs.ListMonitorVMHostsResult
import com.pulumi.azurenative.logz.kotlin.outputs.ListSubAccountMonitoredResourcesResult
import com.pulumi.azurenative.logz.kotlin.outputs.ListSubAccountVMHostsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.logz.kotlin.outputs.GetMetricsSourceResult.Companion.toKotlin as getMetricsSourceResultToKotlin
import com.pulumi.azurenative.logz.kotlin.outputs.GetMetricsSourceTagRuleResult.Companion.toKotlin as getMetricsSourceTagRuleResultToKotlin
import com.pulumi.azurenative.logz.kotlin.outputs.GetMonitorResult.Companion.toKotlin as getMonitorResultToKotlin
import com.pulumi.azurenative.logz.kotlin.outputs.GetSubAccountResult.Companion.toKotlin as getSubAccountResultToKotlin
import com.pulumi.azurenative.logz.kotlin.outputs.GetSubAccountTagRuleResult.Companion.toKotlin as getSubAccountTagRuleResultToKotlin
import com.pulumi.azurenative.logz.kotlin.outputs.GetTagRuleResult.Companion.toKotlin as getTagRuleResultToKotlin
import com.pulumi.azurenative.logz.kotlin.outputs.ListMonitorMonitoredResourcesResult.Companion.toKotlin as listMonitorMonitoredResourcesResultToKotlin
import com.pulumi.azurenative.logz.kotlin.outputs.ListMonitorUserRolesResult.Companion.toKotlin as listMonitorUserRolesResultToKotlin
import com.pulumi.azurenative.logz.kotlin.outputs.ListMonitorVMHostsResult.Companion.toKotlin as listMonitorVMHostsResultToKotlin
import com.pulumi.azurenative.logz.kotlin.outputs.ListSubAccountMonitoredResourcesResult.Companion.toKotlin as listSubAccountMonitoredResourcesResultToKotlin
import com.pulumi.azurenative.logz.kotlin.outputs.ListSubAccountVMHostsResult.Companion.toKotlin as listSubAccountVMHostsResultToKotlin

public object LogzFunctions {
    /**
     *
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getMetricsSource(argument: GetMetricsSourcePlainArgs): GetMetricsSourceResult =
        getMetricsSourceResultToKotlin(getMetricsSourcePlain(argument.toJava()).await())

    /**
     * @see [getMetricsSource].
     * @param metricsSourceName Metrics Account resource name
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getMetricsSource(
        metricsSourceName: String,
        monitorName: String,
        resourceGroupName: String,
    ): GetMetricsSourceResult {
        val argument = GetMetricsSourcePlainArgs(
            metricsSourceName = metricsSourceName,
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return getMetricsSourceResultToKotlin(getMetricsSourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getMetricsSource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logz&#46;kotlin&#46;inputs&#46;GetMetricsSourcePlainArgs].
     * @return null
     */
    public suspend
    fun getMetricsSource(argument: suspend GetMetricsSourcePlainArgsBuilder.() -> Unit):
        GetMetricsSourceResult {
        val builder = GetMetricsSourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMetricsSourceResultToKotlin(getMetricsSourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Capture metrics of Azure resources based on ARM tags.
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return Capture metrics of Azure resources based on ARM tags.
     */
    public suspend fun getMetricsSourceTagRule(argument: GetMetricsSourceTagRulePlainArgs):
        GetMetricsSourceTagRuleResult =
        getMetricsSourceTagRuleResultToKotlin(getMetricsSourceTagRulePlain(argument.toJava()).await())

    /**
     * @see [getMetricsSourceTagRule].
     * @param metricsSourceName Metrics Account resource name
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param ruleSetName
     * @return Capture metrics of Azure resources based on ARM tags.
     */
    public suspend fun getMetricsSourceTagRule(
        metricsSourceName: String,
        monitorName: String,
        resourceGroupName: String,
        ruleSetName: String,
    ): GetMetricsSourceTagRuleResult {
        val argument = GetMetricsSourceTagRulePlainArgs(
            metricsSourceName = metricsSourceName,
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
            ruleSetName = ruleSetName,
        )
        return getMetricsSourceTagRuleResultToKotlin(getMetricsSourceTagRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getMetricsSourceTagRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logz&#46;kotlin&#46;inputs&#46;GetMetricsSourceTagRulePlainArgs].
     * @return Capture metrics of Azure resources based on ARM tags.
     */
    public suspend
    fun getMetricsSourceTagRule(argument: suspend GetMetricsSourceTagRulePlainArgsBuilder.() -> Unit):
        GetMetricsSourceTagRuleResult {
        val builder = GetMetricsSourceTagRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMetricsSourceTagRuleResultToKotlin(getMetricsSourceTagRulePlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getMonitor(argument: GetMonitorPlainArgs): GetMonitorResult =
        getMonitorResultToKotlin(getMonitorPlain(argument.toJava()).await())

    /**
     * @see [getMonitor].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getMonitor(monitorName: String, resourceGroupName: String): GetMonitorResult {
        val argument = GetMonitorPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return getMonitorResultToKotlin(getMonitorPlain(argument.toJava()).await())
    }

    /**
     * @see [getMonitor].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logz&#46;kotlin&#46;inputs&#46;GetMonitorPlainArgs].
     * @return null
     */
    public suspend fun getMonitor(argument: suspend GetMonitorPlainArgsBuilder.() -> Unit):
        GetMonitorResult {
        val builder = GetMonitorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMonitorResultToKotlin(getMonitorPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getSubAccount(argument: GetSubAccountPlainArgs): GetSubAccountResult =
        getSubAccountResultToKotlin(getSubAccountPlain(argument.toJava()).await())

    /**
     * @see [getSubAccount].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param subAccountName Sub Account resource name
     * @return null
     */
    public suspend fun getSubAccount(
        monitorName: String,
        resourceGroupName: String,
        subAccountName: String,
    ): GetSubAccountResult {
        val argument = GetSubAccountPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
            subAccountName = subAccountName,
        )
        return getSubAccountResultToKotlin(getSubAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logz&#46;kotlin&#46;inputs&#46;GetSubAccountPlainArgs].
     * @return null
     */
    public suspend fun getSubAccount(argument: suspend GetSubAccountPlainArgsBuilder.() -> Unit):
        GetSubAccountResult {
        val builder = GetSubAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubAccountResultToKotlin(getSubAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Capture logs and metrics of Azure resources based on ARM tags.
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return Capture logs and metrics of Azure resources based on ARM tags.
     */
    public suspend fun getSubAccountTagRule(argument: GetSubAccountTagRulePlainArgs):
        GetSubAccountTagRuleResult =
        getSubAccountTagRuleResultToKotlin(getSubAccountTagRulePlain(argument.toJava()).await())

    /**
     * @see [getSubAccountTagRule].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param ruleSetName
     * @param subAccountName Sub Account resource name
     * @return Capture logs and metrics of Azure resources based on ARM tags.
     */
    public suspend fun getSubAccountTagRule(
        monitorName: String,
        resourceGroupName: String,
        ruleSetName: String,
        subAccountName: String,
    ): GetSubAccountTagRuleResult {
        val argument = GetSubAccountTagRulePlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
            ruleSetName = ruleSetName,
            subAccountName = subAccountName,
        )
        return getSubAccountTagRuleResultToKotlin(getSubAccountTagRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getSubAccountTagRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logz&#46;kotlin&#46;inputs&#46;GetSubAccountTagRulePlainArgs].
     * @return Capture logs and metrics of Azure resources based on ARM tags.
     */
    public suspend
    fun getSubAccountTagRule(argument: suspend GetSubAccountTagRulePlainArgsBuilder.() -> Unit):
        GetSubAccountTagRuleResult {
        val builder = GetSubAccountTagRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubAccountTagRuleResultToKotlin(getSubAccountTagRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Capture logs and metrics of Azure resources based on ARM tags.
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return Capture logs and metrics of Azure resources based on ARM tags.
     */
    public suspend fun getTagRule(argument: GetTagRulePlainArgs): GetTagRuleResult =
        getTagRuleResultToKotlin(getTagRulePlain(argument.toJava()).await())

    /**
     * @see [getTagRule].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param ruleSetName
     * @return Capture logs and metrics of Azure resources based on ARM tags.
     */
    public suspend fun getTagRule(
        monitorName: String,
        resourceGroupName: String,
        ruleSetName: String,
    ): GetTagRuleResult {
        val argument = GetTagRulePlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
            ruleSetName = ruleSetName,
        )
        return getTagRuleResultToKotlin(getTagRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getTagRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logz&#46;kotlin&#46;inputs&#46;GetTagRulePlainArgs].
     * @return Capture logs and metrics of Azure resources based on ARM tags.
     */
    public suspend fun getTagRule(argument: suspend GetTagRulePlainArgsBuilder.() -> Unit):
        GetTagRuleResult {
        val builder = GetTagRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTagRuleResultToKotlin(getTagRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Response of a list operation.
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return Response of a list operation.
     */
    public suspend
    fun listMonitorMonitoredResources(argument: ListMonitorMonitoredResourcesPlainArgs):
        ListMonitorMonitoredResourcesResult =
        listMonitorMonitoredResourcesResultToKotlin(listMonitorMonitoredResourcesPlain(argument.toJava()).await())

    /**
     * @see [listMonitorMonitoredResources].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response of a list operation.
     */
    public suspend fun listMonitorMonitoredResources(monitorName: String, resourceGroupName: String):
        ListMonitorMonitoredResourcesResult {
        val argument = ListMonitorMonitoredResourcesPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return listMonitorMonitoredResourcesResultToKotlin(listMonitorMonitoredResourcesPlain(argument.toJava()).await())
    }

    /**
     * @see [listMonitorMonitoredResources].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logz&#46;kotlin&#46;inputs&#46;ListMonitorMonitoredResourcesPlainArgs].
     * @return Response of a list operation.
     */
    public suspend
    fun listMonitorMonitoredResources(argument: suspend ListMonitorMonitoredResourcesPlainArgsBuilder.() -> Unit):
        ListMonitorMonitoredResourcesResult {
        val builder = ListMonitorMonitoredResourcesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listMonitorMonitoredResourcesResultToKotlin(listMonitorMonitoredResourcesPlain(builtArgument.toJava()).await())
    }

    /**
     * Response for list of user's role for Logz.io account.
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return Response for list of user's role for Logz.io account.
     */
    public suspend fun listMonitorUserRoles(argument: ListMonitorUserRolesPlainArgs):
        ListMonitorUserRolesResult =
        listMonitorUserRolesResultToKotlin(listMonitorUserRolesPlain(argument.toJava()).await())

    /**
     * @see [listMonitorUserRoles].
     * @param emailAddress Email of the user used by Logz for contacting them if needed
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response for list of user's role for Logz.io account.
     */
    public suspend fun listMonitorUserRoles(
        emailAddress: String? = null,
        monitorName: String,
        resourceGroupName: String,
    ): ListMonitorUserRolesResult {
        val argument = ListMonitorUserRolesPlainArgs(
            emailAddress = emailAddress,
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return listMonitorUserRolesResultToKotlin(listMonitorUserRolesPlain(argument.toJava()).await())
    }

    /**
     * @see [listMonitorUserRoles].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logz&#46;kotlin&#46;inputs&#46;ListMonitorUserRolesPlainArgs].
     * @return Response for list of user's role for Logz.io account.
     */
    public suspend
    fun listMonitorUserRoles(argument: suspend ListMonitorUserRolesPlainArgsBuilder.() -> Unit):
        ListMonitorUserRolesResult {
        val builder = ListMonitorUserRolesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listMonitorUserRolesResultToKotlin(listMonitorUserRolesPlain(builtArgument.toJava()).await())
    }

    /**
     * Response of a list VM Host Update Operation.
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return Response of a list VM Host Update Operation.
     */
    public suspend fun listMonitorVMHosts(argument: ListMonitorVMHostsPlainArgs):
        ListMonitorVMHostsResult =
        listMonitorVMHostsResultToKotlin(listMonitorVMHostsPlain(argument.toJava()).await())

    /**
     * @see [listMonitorVMHosts].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response of a list VM Host Update Operation.
     */
    public suspend fun listMonitorVMHosts(monitorName: String, resourceGroupName: String):
        ListMonitorVMHostsResult {
        val argument = ListMonitorVMHostsPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return listMonitorVMHostsResultToKotlin(listMonitorVMHostsPlain(argument.toJava()).await())
    }

    /**
     * @see [listMonitorVMHosts].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logz&#46;kotlin&#46;inputs&#46;ListMonitorVMHostsPlainArgs].
     * @return Response of a list VM Host Update Operation.
     */
    public suspend
    fun listMonitorVMHosts(argument: suspend ListMonitorVMHostsPlainArgsBuilder.() -> Unit):
        ListMonitorVMHostsResult {
        val builder = ListMonitorVMHostsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listMonitorVMHostsResultToKotlin(listMonitorVMHostsPlain(builtArgument.toJava()).await())
    }

    /**
     * Response of a list operation.
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return Response of a list operation.
     */
    public suspend
    fun listSubAccountMonitoredResources(argument: ListSubAccountMonitoredResourcesPlainArgs):
        ListSubAccountMonitoredResourcesResult =
        listSubAccountMonitoredResourcesResultToKotlin(listSubAccountMonitoredResourcesPlain(argument.toJava()).await())

    /**
     * @see [listSubAccountMonitoredResources].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param subAccountName Sub Account resource name
     * @return Response of a list operation.
     */
    public suspend fun listSubAccountMonitoredResources(
        monitorName: String,
        resourceGroupName: String,
        subAccountName: String,
    ): ListSubAccountMonitoredResourcesResult {
        val argument = ListSubAccountMonitoredResourcesPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
            subAccountName = subAccountName,
        )
        return listSubAccountMonitoredResourcesResultToKotlin(listSubAccountMonitoredResourcesPlain(argument.toJava()).await())
    }

    /**
     * @see [listSubAccountMonitoredResources].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logz&#46;kotlin&#46;inputs&#46;ListSubAccountMonitoredResourcesPlainArgs].
     * @return Response of a list operation.
     */
    public suspend
    fun listSubAccountMonitoredResources(argument: suspend ListSubAccountMonitoredResourcesPlainArgsBuilder.() -> Unit):
        ListSubAccountMonitoredResourcesResult {
        val builder = ListSubAccountMonitoredResourcesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listSubAccountMonitoredResourcesResultToKotlin(listSubAccountMonitoredResourcesPlain(builtArgument.toJava()).await())
    }

    /**
     * Response of a list VM Host Update Operation.
     * Azure REST API version: 2022-01-01-preview.
     * @param argument null
     * @return Response of a list VM Host Update Operation.
     */
    public suspend fun listSubAccountVMHosts(argument: ListSubAccountVMHostsPlainArgs):
        ListSubAccountVMHostsResult =
        listSubAccountVMHostsResultToKotlin(listSubAccountVMHostsPlain(argument.toJava()).await())

    /**
     * @see [listSubAccountVMHosts].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param subAccountName Sub Account resource name
     * @return Response of a list VM Host Update Operation.
     */
    public suspend fun listSubAccountVMHosts(
        monitorName: String,
        resourceGroupName: String,
        subAccountName: String,
    ): ListSubAccountVMHostsResult {
        val argument = ListSubAccountVMHostsPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
            subAccountName = subAccountName,
        )
        return listSubAccountVMHostsResultToKotlin(listSubAccountVMHostsPlain(argument.toJava()).await())
    }

    /**
     * @see [listSubAccountVMHosts].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;logz&#46;kotlin&#46;inputs&#46;ListSubAccountVMHostsPlainArgs].
     * @return Response of a list VM Host Update Operation.
     */
    public suspend
    fun listSubAccountVMHosts(argument: suspend ListSubAccountVMHostsPlainArgsBuilder.() -> Unit):
        ListSubAccountVMHostsResult {
        val builder = ListSubAccountVMHostsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listSubAccountVMHostsResultToKotlin(listSubAccountVMHostsPlain(builtArgument.toJava()).await())
    }
}
