@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state.
 */
public enum class MarketplaceSubscriptionStatus(
    public val javaValue: com.pulumi.azurenative.logz.enums.MarketplaceSubscriptionStatus,
) : ConvertibleToJava<com.pulumi.azurenative.logz.enums.MarketplaceSubscriptionStatus> {
    Active(com.pulumi.azurenative.logz.enums.MarketplaceSubscriptionStatus.Active),
    Suspended(com.pulumi.azurenative.logz.enums.MarketplaceSubscriptionStatus.Suspended),
    ;

    override fun toJava(): com.pulumi.azurenative.logz.enums.MarketplaceSubscriptionStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logz.enums.MarketplaceSubscriptionStatus):
            MarketplaceSubscriptionStatus =
            MarketplaceSubscriptionStatus.values().first { it.javaValue == javaType }
    }
}
