@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.GetMetricsSourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metricsSourceName Metrics Account resource name
 * @property monitorName Monitor resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetMetricsSourcePlainArgs(
    public val metricsSourceName: String,
    public val monitorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.GetMetricsSourcePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.inputs.GetMetricsSourcePlainArgs =
        com.pulumi.azurenative.logz.inputs.GetMetricsSourcePlainArgs.builder()
            .metricsSourceName(metricsSourceName.let({ args0 -> args0 }))
            .monitorName(monitorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMetricsSourcePlainArgs].
 */
@PulumiTagMarker
public class GetMetricsSourcePlainArgsBuilder internal constructor() {
    private var metricsSourceName: String? = null

    private var monitorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Metrics Account resource name
     */
    @JvmName("ctrcyfhvfykjakyq")
    public suspend fun metricsSourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.metricsSourceName = mapped
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("ednjqqcylreadpro")
    public suspend fun monitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.monitorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hsveleifesckkayh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMetricsSourcePlainArgs = GetMetricsSourcePlainArgs(
        metricsSourceName = metricsSourceName ?: throw PulumiNullFieldException("metricsSourceName"),
        monitorName = monitorName ?: throw PulumiNullFieldException("monitorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
