@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.GetMetricsSourceTagRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metricsSourceName Metrics Account resource name
 * @property monitorName Monitor resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleSetName
 */
public data class GetMetricsSourceTagRulePlainArgs(
    public val metricsSourceName: String,
    public val monitorName: String,
    public val resourceGroupName: String,
    public val ruleSetName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.GetMetricsSourceTagRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.inputs.GetMetricsSourceTagRulePlainArgs =
        com.pulumi.azurenative.logz.inputs.GetMetricsSourceTagRulePlainArgs.builder()
            .metricsSourceName(metricsSourceName.let({ args0 -> args0 }))
            .monitorName(monitorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleSetName(ruleSetName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMetricsSourceTagRulePlainArgs].
 */
@PulumiTagMarker
public class GetMetricsSourceTagRulePlainArgsBuilder internal constructor() {
    private var metricsSourceName: String? = null

    private var monitorName: String? = null

    private var resourceGroupName: String? = null

    private var ruleSetName: String? = null

    /**
     * @param value Metrics Account resource name
     */
    @JvmName("aguuapwefhifralw")
    public suspend fun metricsSourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.metricsSourceName = mapped
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("mvaobegkdmtufriu")
    public suspend fun monitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.monitorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ffjnwusdeuoxwyoo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("plbeunrmlrmummvm")
    public suspend fun ruleSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleSetName = mapped
    }

    internal fun build(): GetMetricsSourceTagRulePlainArgs = GetMetricsSourceTagRulePlainArgs(
        metricsSourceName = metricsSourceName ?: throw PulumiNullFieldException("metricsSourceName"),
        monitorName = monitorName ?: throw PulumiNullFieldException("monitorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        ruleSetName = ruleSetName ?: throw PulumiNullFieldException("ruleSetName"),
    )
}
