@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.ListSubAccountVMHostsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property monitorName Monitor resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property subAccountName Sub Account resource name
 */
public data class ListSubAccountVMHostsPlainArgs(
    public val monitorName: String,
    public val resourceGroupName: String,
    public val subAccountName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.ListSubAccountVMHostsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.inputs.ListSubAccountVMHostsPlainArgs =
        com.pulumi.azurenative.logz.inputs.ListSubAccountVMHostsPlainArgs.builder()
            .monitorName(monitorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .subAccountName(subAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListSubAccountVMHostsPlainArgs].
 */
@PulumiTagMarker
public class ListSubAccountVMHostsPlainArgsBuilder internal constructor() {
    private var monitorName: String? = null

    private var resourceGroupName: String? = null

    private var subAccountName: String? = null

    /**
     * @param value Monitor resource name
     */
    @JvmName("cqcmllywnjmecadg")
    public suspend fun monitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.monitorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tujutytcyeucduqr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Sub Account resource name
     */
    @JvmName("gjbnobfpkdejgiea")
    public suspend fun subAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.subAccountName = mapped
    }

    internal fun build(): ListSubAccountVMHostsPlainArgs = ListSubAccountVMHostsPlainArgs(
        monitorName = monitorName ?: throw PulumiNullFieldException("monitorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        subAccountName = subAccountName ?: throw PulumiNullFieldException("subAccountName"),
    )
}
