@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.MonitorPropertiesArgs.builder
import com.pulumi.azurenative.logz.kotlin.enums.MarketplaceSubscriptionStatus
import com.pulumi.azurenative.logz.kotlin.enums.MonitoringStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties specific to the monitor resource.
 * @property logzOrganizationProperties
 * @property marketplaceSubscriptionStatus Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state.
 * @property monitoringStatus Flag specifying if the resource monitoring is enabled or disabled.
 * @property planData
 * @property userInfo
 */
public data class MonitorPropertiesArgs(
    public val logzOrganizationProperties: Output<LogzOrganizationPropertiesArgs>? = null,
    public val marketplaceSubscriptionStatus: Output<Either<String, MarketplaceSubscriptionStatus>>? =
        null,
    public val monitoringStatus: Output<Either<String, MonitoringStatus>>? = null,
    public val planData: Output<PlanDataArgs>? = null,
    public val userInfo: Output<UserInfoArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.MonitorPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.inputs.MonitorPropertiesArgs =
        com.pulumi.azurenative.logz.inputs.MonitorPropertiesArgs.builder()
            .logzOrganizationProperties(
                logzOrganizationProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .marketplaceSubscriptionStatus(
                marketplaceSubscriptionStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .monitoringStatus(
                monitoringStatus?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .planData(planData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userInfo(userInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MonitorPropertiesArgs].
 */
@PulumiTagMarker
public class MonitorPropertiesArgsBuilder internal constructor() {
    private var logzOrganizationProperties: Output<LogzOrganizationPropertiesArgs>? = null

    private var marketplaceSubscriptionStatus: Output<Either<String, MarketplaceSubscriptionStatus>>? =
        null

    private var monitoringStatus: Output<Either<String, MonitoringStatus>>? = null

    private var planData: Output<PlanDataArgs>? = null

    private var userInfo: Output<UserInfoArgs>? = null

    /**
     * @param value
     */
    @JvmName("coodhyhpabuwsybx")
    public suspend fun logzOrganizationProperties(`value`: Output<LogzOrganizationPropertiesArgs>) {
        this.logzOrganizationProperties = value
    }

    /**
     * @param value Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state.
     */
    @JvmName("jyyneagtfuogoiee")
    public suspend
    fun marketplaceSubscriptionStatus(`value`: Output<Either<String, MarketplaceSubscriptionStatus>>) {
        this.marketplaceSubscriptionStatus = value
    }

    /**
     * @param value Flag specifying if the resource monitoring is enabled or disabled.
     */
    @JvmName("jvmlsoqwxbeefmnu")
    public suspend fun monitoringStatus(`value`: Output<Either<String, MonitoringStatus>>) {
        this.monitoringStatus = value
    }

    /**
     * @param value
     */
    @JvmName("ijcgoyrixfqdlcmy")
    public suspend fun planData(`value`: Output<PlanDataArgs>) {
        this.planData = value
    }

    /**
     * @param value
     */
    @JvmName("xuhctsuqkgmxoelj")
    public suspend fun userInfo(`value`: Output<UserInfoArgs>) {
        this.userInfo = value
    }

    /**
     * @param value
     */
    @JvmName("ssdonrfenapwrxtq")
    public suspend fun logzOrganizationProperties(`value`: LogzOrganizationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logzOrganizationProperties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rslrspftilggdsce")
    public suspend
    fun logzOrganizationProperties(argument: suspend LogzOrganizationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = LogzOrganizationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logzOrganizationProperties = mapped
    }

    /**
     * @param value Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state.
     */
    @JvmName("dpkravpndomqixwi")
    public suspend
    fun marketplaceSubscriptionStatus(`value`: Either<String, MarketplaceSubscriptionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketplaceSubscriptionStatus = mapped
    }

    /**
     * @param value Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state.
     */
    @JvmName("qraurunofktxkwed")
    public fun marketplaceSubscriptionStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MarketplaceSubscriptionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.marketplaceSubscriptionStatus = mapped
    }

    /**
     * @param value Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state.
     */
    @JvmName("idbsvvbjavgixwmb")
    public fun marketplaceSubscriptionStatus(`value`: MarketplaceSubscriptionStatus) {
        val toBeMapped = Either.ofRight<String, MarketplaceSubscriptionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.marketplaceSubscriptionStatus = mapped
    }

    /**
     * @param value Flag specifying if the resource monitoring is enabled or disabled.
     */
    @JvmName("wlvscpyoxhkgisto")
    public suspend fun monitoringStatus(`value`: Either<String, MonitoringStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringStatus = mapped
    }

    /**
     * @param value Flag specifying if the resource monitoring is enabled or disabled.
     */
    @JvmName("vnanlymeanukrlas")
    public fun monitoringStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MonitoringStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitoringStatus = mapped
    }

    /**
     * @param value Flag specifying if the resource monitoring is enabled or disabled.
     */
    @JvmName("jrotlajdvsvdcnuc")
    public fun monitoringStatus(`value`: MonitoringStatus) {
        val toBeMapped = Either.ofRight<String, MonitoringStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitoringStatus = mapped
    }

    /**
     * @param value
     */
    @JvmName("dnyehggvpuwysvwr")
    public suspend fun planData(`value`: PlanDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planData = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hgtubxacwdtgmkjy")
    public suspend fun planData(argument: suspend PlanDataArgsBuilder.() -> Unit) {
        val toBeMapped = PlanDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.planData = mapped
    }

    /**
     * @param value
     */
    @JvmName("gevfocxicipaopqq")
    public suspend fun userInfo(`value`: UserInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userInfo = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dhrlcjaevbnpgvuw")
    public suspend fun userInfo(argument: suspend UserInfoArgsBuilder.() -> Unit) {
        val toBeMapped = UserInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userInfo = mapped
    }

    internal fun build(): MonitorPropertiesArgs = MonitorPropertiesArgs(
        logzOrganizationProperties = logzOrganizationProperties,
        marketplaceSubscriptionStatus = marketplaceSubscriptionStatus,
        monitoringStatus = monitoringStatus,
        planData = planData,
        userInfo = userInfo,
    )
}
