@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property id ARM id of the monitor resource.
 * @property identity
 * @property location
 * @property name Name of the monitor resource.
 * @property properties Properties specific to the monitor resource.
 * @property systemData The system metadata relating to this resource
 * @property tags
 * @property type The type of the monitor resource.
 */
public data class GetMetricsSourceResult(
    public val id: String,
    public val identity: IdentityPropertiesResponse? = null,
    public val location: String,
    public val name: String,
    public val properties: MonitorPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logz.outputs.GetMetricsSourceResult):
            GetMetricsSourceResult = GetMetricsSourceResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logz.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.logz.kotlin.outputs.MonitorPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.logz.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
