@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Capture logs and metrics of Azure resources based on ARM tags.
 * @property id The id of the rule set.
 * @property name Name of the rule set.
 * @property properties Definition of the properties for a TagRules resource.
 * @property systemData The system metadata relating to this resource
 * @property type The type of the rule set.
 */
public data class GetSubAccountTagRuleResult(
    public val id: String,
    public val name: String,
    public val properties: MonitoringTagRulesPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logz.outputs.GetSubAccountTagRuleResult):
            GetSubAccountTagRuleResult = GetSubAccountTagRuleResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.logz.kotlin.outputs.MonitoringTagRulesPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.logz.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
