@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Response for list of user's role for Logz.io account.
 * @property nextLink Link to the next set of results, if any.
 * @property value List of user roles for Logz.io account.
 */
public data class ListMonitorUserRolesResult(
    public val nextLink: String? = null,
    public val `value`: List<UserRoleResponseResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logz.outputs.ListMonitorUserRolesResult):
            ListMonitorUserRolesResult = ListMonitorUserRolesResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logz.kotlin.outputs.UserRoleResponseResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
