@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Response of a list VM Host Update Operation.
 * @property nextLink Link to the next set of results, if any.
 * @property value Response of a list vm host update operation.
 */
public data class ListSubAccountVMHostsResult(
    public val nextLink: String? = null,
    public val `value`: List<VMResourcesResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logz.outputs.ListSubAccountVMHostsResult):
            ListSubAccountVMHostsResult = ListSubAccountVMHostsResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logz.kotlin.outputs.VMResourcesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
