@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property billingCycle different billing cycles like MONTHLY/WEEKLY. this could be enum
 * @property effectiveDate date when plan was applied
 * @property planDetails plan id as published by Logz
 * @property usageType different usage type like PAYG/COMMITTED. this could be enum
 */
public data class PlanDataResponse(
    public val billingCycle: String? = null,
    public val effectiveDate: String? = null,
    public val planDetails: String? = null,
    public val usageType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logz.outputs.PlanDataResponse):
            PlanDataResponse = PlanDataResponse(
            billingCycle = javaType.billingCycle().map({ args0 -> args0 }).orElse(null),
            effectiveDate = javaType.effectiveDate().map({ args0 -> args0 }).orElse(null),
            planDetails = javaType.planDetails().map({ args0 -> args0 }).orElse(null),
            usageType = javaType.usageType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
